/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.action;

import io.lucenia.notifications.metrics.Metrics;
import io.skylite.SkyliteSecurityException;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.indices.InvalidIndexNameException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PluginBaseAction<Request extends ActionRequest, Response extends ActionResponse>
extends HandledTransportAction<ActionRequest, Response> {
    private static final Logger log = LogManager.getLogger(PluginBaseAction.class);
    protected final Client client;
    private final ExecutorService executor;

    protected PluginBaseAction(String actionName, TransportService transportService, Client client, ActionFilters actionFilters, Writeable.Reader<ActionRequest> requestReader) {
        super(actionName, transportService, actionFilters, requestReader);
        this.client = client;
        this.executor = client.threadPool().executor("generic");
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<Response> listener) {
        String userStr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        User user = User.parse((String)userStr);
        ThreadContext.StoredContext storedContext = this.client.threadPool().getThreadContext().newStoredContext(false);
        this.executor.execute(() -> {
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                storedContext.restore();
                Response response = this.executeRequest(request, user);
                listener.onResponse(response);
            }
            catch (SkyliteSecurityException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_OS_SECURITY_EXCEPTION.getCounter().increment();
                log.warn("{}:SkyliteSecurityException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException("Permissions denied: " + e.getMessage() + " - Contact administrator", RestStatus.FORBIDDEN, new Object[0])));
            }
            catch (SkyliteStatusException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_OS_STATUS_EXCEPTION.getCounter().increment();
                log.warn("{}:SkyliteStatusException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)e));
            }
            catch (VersionConflictEngineException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION.getCounter().increment();
                log.warn("{}:VersionConflictEngineException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.CONFLICT, new Object[0])));
            }
            catch (IndexNotFoundException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION.getCounter().increment();
                log.warn("{}:IndexNotFoundException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.NOT_FOUND, new Object[0])));
            }
            catch (InvalidIndexNameException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION.getCounter().increment();
                log.warn("{}:InvalidIndexNameException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.BAD_REQUEST, new Object[0])));
            }
            catch (IllegalArgumentException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION.getCounter().increment();
                log.warn("{}:IllegalArgumentException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.BAD_REQUEST, new Object[0])));
            }
            catch (IllegalStateException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION.getCounter().increment();
                log.warn("{}:IllegalStateException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.SERVICE_UNAVAILABLE, new Object[0])));
            }
            catch (IOException e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_IO_EXCEPTION.getCounter().increment();
                log.error("{}:Uncaught IOException: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.FAILED_DEPENDENCY, new Object[0])));
            }
            catch (Exception e) {
                Metrics.NOTIFICATIONS_EXCEPTIONS_INTERNAL_SERVER_ERROR.getCounter().increment();
                log.error("{}:Uncaught Exception: {}", (Object)"notifications-core", (Object)e);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(e.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        });
    }

    protected abstract Response executeRequest(Request var1, User var2) throws Exception;
}

