/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.action;

import io.lucenia.notifications.model.SendTestNotificationRequest;
import io.lucenia.notifications.send.SendTestNotificationActionHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.SendNotificationResponse;
import io.skylite.core.notifications.model.ChannelMessage;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendTestNotificationAction
extends HandledTransportAction<SendTestNotificationRequest, SendNotificationResponse> {
    private static final Logger log = LogManager.getLogger(SendTestNotificationAction.class);
    public static final String NAME = "cluster:admin/lucenia/notifications/test_notification";
    public static final ActionType<SendNotificationResponse> ACTION_TYPE = new ActionType("cluster:admin/lucenia/notifications/test_notification", SendNotificationResponse::new);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public SendTestNotificationAction(TransportService transportService, Client client, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super(NAME, transportService, actionFilters, SendTestNotificationRequest.READER);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    protected void doExecute(Task task, SendTestNotificationRequest request, final ActionListener<SendNotificationResponse> listener) {
        EventSource source = SendTestNotificationActionHelper.generateEventSource(request.getConfigId());
        ChannelMessage message = SendTestNotificationActionHelper.generateMessage(request.getConfigId());
        List<String> channelIds = Collections.singletonList(request.getConfigId());
        NotificationsPluginInterface.sendNotification((NodeClient)((NodeClient)this.client), (EventSource)source, (ChannelMessage)message, channelIds, (ActionListener)new ActionListener<SendNotificationResponse>(this){

            public void onResponse(SendNotificationResponse sendNotificationResponse) {
                log.info("{}:SendTestNotificationAction-send:{}", (Object)"notifications-core", (Object)sendNotificationResponse.getNotificationEvent());
                listener.onResponse((Object)sendNotificationResponse);
            }

            public void onFailure(Exception exception) {
                log.error("{}:SendTestNotificationAction-send Error:{}", (Object)"notifications-core", (Object)exception);
                listener.onFailure(exception);
            }
        });
    }
}

