/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.index;

import io.lucenia.notifications.index.ConfigOperations;
import io.lucenia.notifications.metrics.Metrics;
import io.lucenia.notifications.model.DocMetadata;
import io.lucenia.notifications.model.NotificationConfigDoc;
import io.lucenia.notifications.model.NotificationConfigDocInfo;
import io.lucenia.notifications.security.UserAccess;
import io.skylite.SkyliteStatusException;
import io.skylite.core.notifications.action.CreateNotificationConfigRequest;
import io.skylite.core.notifications.action.CreateNotificationConfigResponse;
import io.skylite.core.notifications.action.DeleteNotificationConfigRequest;
import io.skylite.core.notifications.action.DeleteNotificationConfigResponse;
import io.skylite.core.notifications.action.GetChannelListRequest;
import io.skylite.core.notifications.action.GetChannelListResponse;
import io.skylite.core.notifications.action.GetNotificationConfigRequest;
import io.skylite.core.notifications.action.GetNotificationConfigResponse;
import io.skylite.core.notifications.action.UpdateNotificationConfigRequest;
import io.skylite.core.notifications.action.UpdateNotificationConfigResponse;
import io.skylite.core.notifications.model.Channel;
import io.skylite.core.notifications.model.ChannelList;
import io.skylite.core.notifications.model.Chime;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.notifications.model.Email;
import io.skylite.core.notifications.model.EmailGroup;
import io.skylite.core.notifications.model.MicrosoftTeams;
import io.skylite.core.notifications.model.NotificationConfig;
import io.skylite.core.notifications.model.NotificationConfigInfo;
import io.skylite.core.notifications.model.NotificationConfigSearchResult;
import io.skylite.core.notifications.model.SesAccount;
import io.skylite.core.notifications.model.Slack;
import io.skylite.core.notifications.model.SmtpAccount;
import io.skylite.core.notifications.model.Sns;
import io.skylite.core.notifications.model.Webhook;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigIndexingActions {
    private static final Logger log = LogManager.getLogger(ConfigIndexingActions.class);
    private static ConfigOperations operations;
    private static UserAccess userAccess;

    private ConfigIndexingActions() {
    }

    public static void initialize(ConfigOperations ops, UserAccess access) {
        operations = ops;
        userAccess = access;
    }

    private static void validateSlackConfig(Slack slack, User user) {
        if (!slack.getUrl().matches("https://hooks\\.(?:gov-)?slack\\.com/services.*")) {
            throw new IllegalArgumentException("Wrong Slack url. Should contain \"hooks.slack.com/services/\" or \"hooks.gov-slack.com/services/\"");
        }
    }

    private static void validateChimeConfig(Chime chime, User user) {
        if (!chime.getUrl().matches("https://hooks\\.chime\\.aws/incomingwebhooks/.*\\?token=.*")) {
            throw new IllegalArgumentException("Wrong Chime url. Should contain \"hooks.chime.aws/incomingwebhooks/\" and \"?token=\"");
        }
    }

    private static void validateMicrosoftTeamsConfig(MicrosoftTeams microsoftTeams, User user) {
        if (!microsoftTeams.getUrl().matches("https://.*\\.webhook\\.office\\.com.*")) {
            throw new IllegalArgumentException("Wrong Microsoft Teams url. Should contain \"webhook.office.com\"");
        }
    }

    private static void validateWebhookConfig(Webhook webhook, User user) {
    }

    private static void validateSnsConfig(Sns sns, User user) {
    }

    private static void validateEmailConfig(Email email, User user) throws Exception {
        if (email.getEmailGroupIds().contains(email.getEmailAccountID())) {
            throw new SkyliteStatusException("Config IDs " + email.getEmailAccountID() + " is in both emailAccountID and emailGroupIds", RestStatus.BAD_REQUEST, new Object[0]);
        }
        HashSet<String> configIds = new HashSet<String>();
        configIds.add(email.getEmailAccountID());
        configIds.addAll(email.getEmailGroupIds());
        List<NotificationConfigDocInfo> configDocs = operations.getNotificationConfigs(configIds);
        if (configDocs.size() != configIds.size()) {
            Set availableIds = configDocs.stream().map(doc -> doc.getDocInfo().getId()).collect(Collectors.toSet());
            HashSet<String> missingIds = new HashSet<String>(configIds);
            missingIds.removeAll(availableIds);
            throw new SkyliteStatusException("Config IDs not found:" + String.valueOf(missingIds), RestStatus.NOT_FOUND, new Object[0]);
        }
        for (NotificationConfigDocInfo doc2 : configDocs) {
            DocMetadata currentMetadata;
            ConfigType configType = doc2.getConfigDoc().getConfig().getConfigType();
            String docId = doc2.getDocInfo().getId();
            switch (configType) {
                case EMAIL_GROUP: {
                    if (!docId.equals(email.getEmailAccountID())) break;
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_ACCOUNT_ID.getCounter().increment();
                    throw new SkyliteStatusException("configId " + docId + " is not a valid email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
                case SMTP_ACCOUNT: 
                case SES_ACCOUNT: {
                    if (docId.equals(email.getEmailAccountID())) break;
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID.getCounter().increment();
                    throw new SkyliteStatusException("configId " + docId + " is not a valid email group ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
                default: {
                    Metrics.NOTIFICATIONS_CONFIG_USER_ERROR_NEITHER_EMAIL_NOR_GROUP.getCounter().increment();
                    throw new SkyliteStatusException("configId " + docId + " is not a valid email group ID or email account ID", RestStatus.NOT_ACCEPTABLE, new Object[0]);
                }
            }
            if (userAccess.doesUserHaveAccess(user, (currentMetadata = doc2.getConfigDoc().getMetadata()).getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + docId, RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    private static void validateSmtpAccountConfig(SmtpAccount smtpAccount, User user) {
    }

    private static void validateSesAccountConfig(SesAccount sesAccount, User user) {
    }

    private static void validateEmailGroupConfig(EmailGroup emailGroup, User user) {
    }

    private static void validateConfig(NotificationConfig config, User user) throws Exception {
        switch (config.getConfigType()) {
            case NONE: {
                throw new SkyliteStatusException("NotificationConfig with type NONE is not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
            }
            case SLACK: {
                ConfigIndexingActions.validateSlackConfig((Slack)config.getConfigData(), user);
                break;
            }
            case CHIME: {
                ConfigIndexingActions.validateChimeConfig((Chime)config.getConfigData(), user);
                break;
            }
            case MICROSOFT_TEAMS: {
                ConfigIndexingActions.validateMicrosoftTeamsConfig((MicrosoftTeams)config.getConfigData(), user);
                break;
            }
            case WEBHOOK: {
                ConfigIndexingActions.validateWebhookConfig((Webhook)config.getConfigData(), user);
                break;
            }
            case EMAIL: {
                ConfigIndexingActions.validateEmailConfig((Email)config.getConfigData(), user);
                break;
            }
            case SMTP_ACCOUNT: {
                ConfigIndexingActions.validateSmtpAccountConfig((SmtpAccount)config.getConfigData(), user);
                break;
            }
            case SES_ACCOUNT: {
                ConfigIndexingActions.validateSesAccountConfig((SesAccount)config.getConfigData(), user);
                break;
            }
            case EMAIL_GROUP: {
                ConfigIndexingActions.validateEmailGroupConfig((EmailGroup)config.getConfigData(), user);
                break;
            }
            case SNS: {
                ConfigIndexingActions.validateSnsConfig((Sns)config.getConfigData(), user);
            }
        }
    }

    public static CreateNotificationConfigResponse create(CreateNotificationConfigRequest request, User user) throws Exception {
        log.info("{}:NotificationConfig-create", (Object)"notifications-core");
        userAccess.validateUser(user);
        ConfigIndexingActions.validateConfig(request.getNotificationConfig(), user);
        Instant currentTime = Instant.now();
        DocMetadata metadata = new DocMetadata(currentTime, currentTime, userAccess.getAllAccessInfo(user));
        NotificationConfigDoc configDoc = new NotificationConfigDoc(metadata, request.getNotificationConfig());
        String docId = operations.createNotificationConfig(configDoc, request.getConfigId());
        if (docId == null) {
            Metrics.NOTIFICATIONS_CONFIG_CREATE_SYSTEM_ERROR.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new CreateNotificationConfigResponse(docId);
    }

    public static UpdateNotificationConfigResponse update(UpdateNotificationConfigRequest request, User user) throws Exception {
        log.info("{}:NotificationConfig-update {}", (Object)"notifications-core", (Object)request.getConfigId());
        userAccess.validateUser(user);
        ConfigIndexingActions.validateConfig(request.getNotificationConfig(), user);
        NotificationConfigDocInfo currentConfigDoc = operations.getNotificationConfig(request.getConfigId());
        if (currentConfigDoc == null) {
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + request.getConfigId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
        if (!userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + request.getConfigId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (currentConfigDoc.getConfigDoc().getConfig().getConfigType() != request.getNotificationConfig().getConfigType()) {
            throw new SkyliteStatusException("Config type cannot be changed after creation", RestStatus.CONFLICT, new Object[0]);
        }
        DocMetadata newMetadata = new DocMetadata(Instant.now(), currentMetadata.getCreatedTime(), currentMetadata.getAccess());
        NotificationConfigDoc newConfigData = new NotificationConfigDoc(newMetadata, request.getNotificationConfig());
        if (!operations.updateNotificationConfig(request.getConfigId(), newConfigData)) {
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_SYSTEM_ERROR.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateNotificationConfigResponse(request.getConfigId());
    }

    public static GetNotificationConfigResponse get(GetNotificationConfigRequest request, User user) throws Exception {
        log.info("{}:NotificationConfig-get {}", (Object)"notifications-core", (Object)request);
        userAccess.validateUser(user);
        if (request.getConfigIds().isEmpty()) {
            return ConfigIndexingActions.getAll(request, user);
        }
        if (request.getConfigIds().size() == 1) {
            return ConfigIndexingActions.info((String)request.getConfigIds().iterator().next(), user);
        }
        return ConfigIndexingActions.info(request.getConfigIds(), user);
    }

    private static GetNotificationConfigResponse info(String configId, User user) throws Exception {
        log.info("{}:NotificationConfig-info {}", (Object)"notifications-core", (Object)configId);
        NotificationConfigDocInfo configDoc = operations.getNotificationConfig(configId);
        if (configDoc == null) {
            Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata metadata = configDoc.getConfigDoc().getMetadata();
        if (!userAccess.doesUserHaveAccess(user, metadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
        }
        NotificationConfigInfo configInfo = new NotificationConfigInfo(configId, metadata.getLastUpdateTime(), metadata.getCreatedTime(), configDoc.getConfigDoc().getConfig());
        return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configInfo));
    }

    private static GetNotificationConfigResponse info(Set<String> configIds, User user) throws Exception {
        log.info("{}:NotificationConfig-info {}", (Object)"notifications-core", configIds);
        List<NotificationConfigDocInfo> configDocs = operations.getNotificationConfigs(configIds);
        if (configDocs.size() != configIds.size()) {
            HashSet<String> mutableSet = new HashSet<String>(configIds);
            for (NotificationConfigDocInfo doc2 : configDocs) {
                mutableSet.remove(doc2.getDocInfo().getId());
            }
            Metrics.NOTIFICATIONS_CONFIG_INFO_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + String.valueOf(mutableSet) + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        for (NotificationConfigDocInfo doc3 : configDocs) {
            DocMetadata currentMetadata = doc3.getConfigDoc().getMetadata();
            if (userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + doc3.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        List configSearchResult = configDocs.stream().map(doc -> new NotificationConfigInfo(doc.getDocInfo().getId(), doc.getConfigDoc().getMetadata().getLastUpdateTime(), doc.getConfigDoc().getMetadata().getCreatedTime(), doc.getConfigDoc().getConfig())).collect(Collectors.toList());
        return new GetNotificationConfigResponse(new NotificationConfigSearchResult(configSearchResult));
    }

    private static GetNotificationConfigResponse getAll(GetNotificationConfigRequest request, User user) throws Exception {
        log.info("{}:NotificationConfig-getAll", (Object)"notifications-core");
        NotificationConfigSearchResult searchResult = operations.getAllNotificationConfigs(userAccess.getSearchAccessInfo(user), request);
        return new GetNotificationConfigResponse(searchResult);
    }

    public static GetChannelListResponse getChannelList(GetChannelListRequest request, User user) throws Exception {
        log.info("{}:getChannelList {}", (Object)"notifications-core", (Object)request);
        userAccess.validateUser(user);
        String supportedChannelListString = String.join((CharSequence)",", ConfigIndexingActions.getSupportedChannelList());
        HashMap<String, String> filterParams = new HashMap<String, String>();
        filterParams.put("config_type", supportedChannelListString);
        GetNotificationConfigRequest getAllRequest = new GetNotificationConfigRequest(Collections.emptySet(), 0, 1000, null, null, filterParams);
        NotificationConfigSearchResult getAllResult = operations.getAllNotificationConfigs(userAccess.getSearchAccessInfo(user), getAllRequest);
        List searchResult = getAllResult.getObjectList().stream().map(info -> new Channel(info.getConfigId(), info.getNotificationConfig().getName(), info.getNotificationConfig().getDescription(), info.getNotificationConfig().getConfigType(), info.getNotificationConfig().isEnabled())).collect(Collectors.toList());
        ChannelList channelList = new ChannelList(searchResult);
        return new GetChannelListResponse(channelList);
    }

    private static List<String> getSupportedChannelList() {
        return Arrays.asList(ConfigType.SLACK.getTag(), ConfigType.CHIME.getTag(), ConfigType.MICROSOFT_TEAMS.getTag(), ConfigType.WEBHOOK.getTag(), ConfigType.EMAIL.getTag(), ConfigType.SNS.getTag());
    }

    private static DeleteNotificationConfigResponse delete(String configId, User user) throws Exception {
        log.info("{}:NotificationConfig-delete {}", (Object)"notifications-core", (Object)configId);
        userAccess.validateUser(user);
        NotificationConfigDocInfo currentConfigDoc = operations.getNotificationConfig(configId);
        if (currentConfigDoc == null) {
            Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_INVALID_CONFIG_ID.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + configId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        DocMetadata currentMetadata = currentConfigDoc.getConfigDoc().getMetadata();
        if (!userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + configId, RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!operations.deleteNotificationConfig(configId)) {
            Metrics.NOTIFICATIONS_CONFIG_DELETE_SYSTEM_ERROR.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + configId + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
        }
        HashMap<String, RestStatus> result = new HashMap<String, RestStatus>();
        result.put(configId, RestStatus.OK);
        return new DeleteNotificationConfigResponse(result);
    }

    private static DeleteNotificationConfigResponse delete(Set<String> configIds, User user) throws Exception {
        log.info("{}:NotificationConfig-delete {}", (Object)"notifications-core", configIds);
        userAccess.validateUser(user);
        List<NotificationConfigDocInfo> configDocs = operations.getNotificationConfigs(configIds);
        if (configDocs.size() != configIds.size()) {
            HashSet<String> mutableSet = new HashSet<String>(configIds);
            for (NotificationConfigDocInfo doc : configDocs) {
                mutableSet.remove(doc.getDocInfo().getId());
            }
            Metrics.NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_SET_NOT_FOUND.getCounter().increment();
            throw new SkyliteStatusException("NotificationConfig " + String.valueOf(mutableSet) + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        for (NotificationConfigDocInfo doc : configDocs) {
            DocMetadata currentMetadata = doc.getConfigDoc().getMetadata();
            if (userAccess.doesUserHaveAccess(user, currentMetadata.getAccess())) continue;
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            throw new SkyliteStatusException("Permission denied for NotificationConfig " + doc.getDocInfo().getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        return new DeleteNotificationConfigResponse(operations.deleteNotificationConfigs(configIds));
    }

    public static DeleteNotificationConfigResponse delete(DeleteNotificationConfigRequest request, User user) throws Exception {
        log.info("{}:NotificationConfig-delete {}", (Object)"notifications-core", (Object)request.getConfigIds());
        if (request.getConfigIds().size() == 1) {
            return ConfigIndexingActions.delete((String)request.getConfigIds().iterator().next(), user);
        }
        return ConfigIndexingActions.delete(request.getConfigIds(), user);
    }
}

