/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.index;

import io.skylite.SkyliteStatusException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.MatchQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.rest.RestStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public final class ConfigQueryHelper {
    private static final String KEY_PREFIX = "config";
    private static final String KEYWORD_SUFFIX = "keyword";
    private static final List<String> NESTED_PATHS = Arrays.asList(ConfigType.EMAIL.getTag() + ".recipient_list", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list");
    private static final Set<String> METADATA_RANGE_FIELDS = new HashSet<String>(Arrays.asList("last_updated_time_ms", "created_time_ms"));
    private static final Set<String> BOOLEAN_FIELDS = new HashSet<String>(Arrays.asList("is_enabled"));
    private static final Set<String> KEYWORD_FIELDS = new HashSet<String>(Arrays.asList("config_type", ConfigType.EMAIL.getTag() + ".email_account_id", ConfigType.EMAIL.getTag() + ".email_group_id_list", ConfigType.SMTP_ACCOUNT.getTag() + ".method", ConfigType.SES_ACCOUNT.getTag() + ".region", "name.keyword", "description.keyword", ConfigType.SLACK.getTag() + ".url.keyword", ConfigType.CHIME.getTag() + ".url.keyword", ConfigType.MICROSOFT_TEAMS.getTag() + ".url.keyword", ConfigType.WEBHOOK.getTag() + ".url.keyword", ConfigType.SMTP_ACCOUNT.getTag() + ".host.keyword", ConfigType.SMTP_ACCOUNT.getTag() + ".from_address.keyword", ConfigType.SNS.getTag() + ".topic_arn.keyword", ConfigType.SNS.getTag() + ".role_arn.keyword", ConfigType.SES_ACCOUNT.getTag() + ".role_arn.keyword", ConfigType.SES_ACCOUNT.getTag() + ".from_address.keyword"));
    private static final Set<String> TEXT_FIELDS = new HashSet<String>(Arrays.asList("name", "description", ConfigType.SLACK.getTag() + ".url", ConfigType.CHIME.getTag() + ".url", ConfigType.MICROSOFT_TEAMS.getTag() + ".url", ConfigType.WEBHOOK.getTag() + ".url", ConfigType.SMTP_ACCOUNT.getTag() + ".host", ConfigType.SMTP_ACCOUNT.getTag() + ".from_address", ConfigType.SNS.getTag() + ".topic_arn", ConfigType.SNS.getTag() + ".role_arn", ConfigType.SES_ACCOUNT.getTag() + ".role_arn", ConfigType.SES_ACCOUNT.getTag() + ".from_address"));
    private static final Set<String> NESTED_KEYWORD_FIELDS = new HashSet<String>(Arrays.asList(ConfigType.EMAIL.getTag() + ".recipient_list.recipient.keyword", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list.recipient.keyword"));
    private static final Set<String> NESTED_TEXT_FIELDS = new HashSet<String>(Arrays.asList(ConfigType.EMAIL.getTag() + ".recipient_list.recipient", ConfigType.EMAIL_GROUP.getTag() + ".recipient_list.recipient"));
    private static final Set<String> METADATA_FIELDS = METADATA_RANGE_FIELDS;
    private static final Set<String> CONFIG_FIELDS = new HashSet<String>();
    private static final Set<String> NESTED_FIELDS;
    private static final Set<String> ALL_FIELDS;
    public static final Set<String> FILTER_PARAMS;

    private ConfigQueryHelper() {
    }

    public static String getSortField(String sortField) {
        if (sortField == null) {
            return "metadata.last_updated_time_ms";
        }
        if (METADATA_RANGE_FIELDS.contains(sortField)) {
            return "metadata." + sortField;
        }
        if (BOOLEAN_FIELDS.contains(sortField)) {
            return "config." + sortField;
        }
        if (KEYWORD_FIELDS.contains(sortField)) {
            return "config." + sortField;
        }
        if (TEXT_FIELDS.contains(sortField)) {
            return "config." + sortField + ".keyword";
        }
        throw new SkyliteStatusException("Sort on " + sortField + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
    }

    public static void addQueryFilters(BoolQueryBuilder query, Map<String, String> filterParams) {
        for (Map.Entry<String, String> entry : filterParams.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("query".equals(key)) {
                query.filter(ConfigQueryHelper.getQueryAllBuilder(value));
                continue;
            }
            if ("text_query".equals(key)) {
                query.filter(ConfigQueryHelper.getTextQueryAllBuilder(value));
                continue;
            }
            if (METADATA_RANGE_FIELDS.contains(key)) {
                query.filter(ConfigQueryHelper.getRangeQueryBuilder(key, value));
                continue;
            }
            if (BOOLEAN_FIELDS.contains(key)) {
                query.filter(ConfigQueryHelper.getTermQueryBuilder(key, value));
                continue;
            }
            if (KEYWORD_FIELDS.contains(key)) {
                query.filter(ConfigQueryHelper.getTermsQueryBuilder(key, value));
                continue;
            }
            if (TEXT_FIELDS.contains(key)) {
                query.filter(ConfigQueryHelper.getMatchQueryBuilder(key, value));
                continue;
            }
            if (NESTED_TEXT_FIELDS.contains(key)) {
                query.filter(ConfigQueryHelper.getNestedMatchQueryBuilder(key, value));
                continue;
            }
            throw new SkyliteStatusException("Query on " + key + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
    }

    private static QueryBuilder getQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        for (String field : CONFIG_FIELDS) {
            allQuery.field("config." + field);
        }
        boolQuery.should((QueryBuilder)allQuery);
        for (String path : NESTED_PATHS) {
            QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
            for (String field : NESTED_FIELDS) {
                if (!field.startsWith(path)) continue;
                allNestedQuery.field("config." + field);
            }
            NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)("config." + path), (QueryBuilder)allNestedQuery, (ScoreMode)ScoreMode.None);
            boolQuery.should((QueryBuilder)nestedFieldQuery);
        }
        return boolQuery;
    }

    private static QueryBuilder getTextQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        for (String field : TEXT_FIELDS) {
            allQuery.field("config." + field);
        }
        boolQuery.should((QueryBuilder)allQuery);
        for (String path : NESTED_PATHS) {
            QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
            for (String field : NESTED_TEXT_FIELDS) {
                if (!field.startsWith(path)) continue;
                allNestedQuery.field("config." + field);
            }
            NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)("config." + path), (QueryBuilder)allNestedQuery, (ScoreMode)ScoreMode.None);
            boolQuery.should((QueryBuilder)nestedFieldQuery);
        }
        return boolQuery;
    }

    private static QueryBuilder getRangeQueryBuilder(String queryKey, String queryValue) {
        String[] range = queryValue.split("\\.\\.");
        if (range.length == 1) {
            return QueryBuilders.termQuery((String)("metadata." + queryKey), (String)queryValue);
        }
        if (range.length == 2) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)("metadata." + queryKey));
            rangeQuery.from((Object)range[0]);
            rangeQuery.to((Object)range[1]);
            return rangeQuery;
        }
        throw new SkyliteStatusException("Invalid Range format " + queryValue + ", allowed format 'exact' or 'from..to'", RestStatus.NOT_ACCEPTABLE, new Object[0]);
    }

    private static QueryBuilder getTermQueryBuilder(String queryKey, String queryValue) {
        return QueryBuilders.termQuery((String)("config." + queryKey), (String)queryValue);
    }

    private static QueryBuilder getTermsQueryBuilder(String queryKey, String queryValue) {
        return QueryBuilders.termsQuery((String)("config." + queryKey), Arrays.asList(queryValue.split(",")));
    }

    private static QueryBuilder getMatchQueryBuilder(String queryKey, String queryValue) {
        return QueryBuilders.matchQuery((String)("config." + queryKey), (Object)queryValue);
    }

    private static QueryBuilder getNestedMatchQueryBuilder(String queryKey, String queryValue) {
        MatchQueryBuilder query = QueryBuilders.matchQuery((String)("config." + queryKey), (Object)queryValue);
        String nestedPath = null;
        for (String path : NESTED_PATHS) {
            if (!queryKey.startsWith(path)) continue;
            nestedPath = path;
            break;
        }
        return QueryBuilders.nestedQuery((String)("config." + nestedPath), (QueryBuilder)query, (ScoreMode)ScoreMode.None);
    }

    static {
        CONFIG_FIELDS.addAll(KEYWORD_FIELDS);
        CONFIG_FIELDS.addAll(TEXT_FIELDS);
        NESTED_FIELDS = new HashSet<String>();
        NESTED_FIELDS.addAll(NESTED_KEYWORD_FIELDS);
        NESTED_FIELDS.addAll(NESTED_TEXT_FIELDS);
        ALL_FIELDS = new HashSet<String>();
        ALL_FIELDS.addAll(METADATA_FIELDS);
        ALL_FIELDS.addAll(CONFIG_FIELDS);
        ALL_FIELDS.addAll(BOOLEAN_FIELDS);
        ALL_FIELDS.addAll(NESTED_FIELDS);
        FILTER_PARAMS = new HashSet<String>();
        FILTER_PARAMS.addAll(ALL_FIELDS);
        FILTER_PARAMS.add("query");
        FILTER_PARAMS.add("text_query");
    }
}

