/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.index;

import io.skylite.SkyliteStatusException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.rest.RestStatus;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilders;

public final class EventQueryHelper {
    private static final String KEY_PREFIX = "event";
    private static final String NESTED_PATH = "event.status_list";
    private static final String KEYWORD_SUFFIX = "keyword";
    private static final Set<String> METADATA_RANGE_FIELDS = new HashSet<String>(Arrays.asList("last_updated_time_ms", "created_time_ms"));
    private static final Set<String> KEYWORD_FIELDS = new HashSet<String>(Arrays.asList("event_source.reference_id", "event_source.severity", "event_source.tags.keyword", "event_source.title.keyword"));
    private static final Set<String> TEXT_FIELDS = new HashSet<String>(Arrays.asList("event_source.tags", "event_source.title"));
    private static final Set<String> NESTED_KEYWORD_FIELDS = new HashSet<String>(Arrays.asList("status_list.config_id", "status_list.config_type", "status_list.email_recipient_status.delivery_status.status_code", "status_list.delivery_status.status_code", "status_list.config_name.keyword", "status_list.email_recipient_status.recipient.keyword", "status_list.email_recipient_status.delivery_status.status_text.keyword", "status_list.delivery_status.status_text.keyword"));
    private static final Set<String> NESTED_TEXT_FIELDS = new HashSet<String>(Arrays.asList("status_list.config_name", "status_list.email_recipient_status.recipient", "status_list.email_recipient_status.delivery_status.status_text", "status_list.delivery_status.status_text"));
    private static final Set<String> METADATA_FIELDS = METADATA_RANGE_FIELDS;
    private static final Set<String> EVENT_FIELDS = new HashSet<String>();
    private static final Set<String> NESTED_FIELDS;
    private static final Set<String> ALL_FIELDS;
    public static final Set<String> FILTER_PARAMS;

    private EventQueryHelper() {
    }

    public static String getSortField(String sortField) {
        if (sortField == null) {
            return "metadata.last_updated_time_ms";
        }
        if (METADATA_RANGE_FIELDS.contains(sortField)) {
            return "metadata." + sortField;
        }
        if (KEYWORD_FIELDS.contains(sortField)) {
            return "event." + sortField;
        }
        if (TEXT_FIELDS.contains(sortField)) {
            return "event." + sortField + ".keyword";
        }
        throw new SkyliteStatusException("Sort on " + sortField + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
    }

    public static void addQueryFilters(BoolQueryBuilder query, Map<String, String> filterParams) {
        BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery();
        for (Map.Entry<String, String> entry : filterParams.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("query".equals(key)) {
                query.filter(EventQueryHelper.getQueryAllBuilder(value));
                continue;
            }
            if ("text_query".equals(key)) {
                query.filter(EventQueryHelper.getTextQueryAllBuilder(value));
                continue;
            }
            if (METADATA_RANGE_FIELDS.contains(key)) {
                query.filter(EventQueryHelper.getRangeQueryBuilder(key, value));
                continue;
            }
            if (KEYWORD_FIELDS.contains(key)) {
                query.filter(EventQueryHelper.getTermsQueryBuilder(key, value));
                continue;
            }
            if (TEXT_FIELDS.contains(key)) {
                query.filter(EventQueryHelper.getMatchQueryBuilder(key, value));
                continue;
            }
            if (NESTED_KEYWORD_FIELDS.contains(key)) {
                nestedQuery.filter(EventQueryHelper.getTermsQueryBuilder(key, value));
                continue;
            }
            if (NESTED_TEXT_FIELDS.contains(key)) {
                nestedQuery.filter(EventQueryHelper.getMatchQueryBuilder(key, value));
                continue;
            }
            throw new SkyliteStatusException("Query on " + key + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
        if (!nestedQuery.filter().isEmpty()) {
            query.filter((QueryBuilder)QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)nestedQuery, (ScoreMode)ScoreMode.None));
        }
    }

    private static QueryBuilder getQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
        for (String field : EVENT_FIELDS) {
            allQuery.field("event." + field);
        }
        for (String field : NESTED_FIELDS) {
            allNestedQuery.field("event." + field);
        }
        NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)allNestedQuery, (ScoreMode)ScoreMode.None);
        boolQuery.should((QueryBuilder)allQuery);
        boolQuery.should((QueryBuilder)nestedFieldQuery);
        return boolQuery;
    }

    private static QueryBuilder getTextQueryAllBuilder(String queryValue) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
        for (String field : TEXT_FIELDS) {
            allQuery.field("event." + field);
        }
        for (String field : NESTED_TEXT_FIELDS) {
            allNestedQuery.field("event." + field);
        }
        NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)allNestedQuery, (ScoreMode)ScoreMode.None);
        boolQuery.should((QueryBuilder)allQuery);
        boolQuery.should((QueryBuilder)nestedFieldQuery);
        return boolQuery;
    }

    private static QueryBuilder getRangeQueryBuilder(String queryKey, String queryValue) {
        String[] range = queryValue.split("\\.\\.");
        if (range.length == 1) {
            return QueryBuilders.termQuery((String)("metadata." + queryKey), (String)queryValue);
        }
        if (range.length == 2) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)("metadata." + queryKey));
            rangeQuery.from((Object)range[0]);
            rangeQuery.to((Object)range[1]);
            return rangeQuery;
        }
        throw new SkyliteStatusException("Invalid Range format " + queryValue + ", allowed format 'exact' or 'from..to'", RestStatus.NOT_ACCEPTABLE, new Object[0]);
    }

    private static QueryBuilder getTermsQueryBuilder(String queryKey, String queryValue) {
        return QueryBuilders.termsQuery((String)("event." + queryKey), Arrays.asList(queryValue.split(",")));
    }

    private static QueryBuilder getMatchQueryBuilder(String queryKey, String queryValue) {
        return QueryBuilders.matchQuery((String)("event." + queryKey), (Object)queryValue);
    }

    static {
        EVENT_FIELDS.addAll(KEYWORD_FIELDS);
        EVENT_FIELDS.addAll(TEXT_FIELDS);
        NESTED_FIELDS = new HashSet<String>();
        NESTED_FIELDS.addAll(NESTED_KEYWORD_FIELDS);
        NESTED_FIELDS.addAll(NESTED_TEXT_FIELDS);
        ALL_FIELDS = new HashSet<String>();
        ALL_FIELDS.addAll(METADATA_FIELDS);
        ALL_FIELDS.addAll(EVENT_FIELDS);
        ALL_FIELDS.addAll(NESTED_FIELDS);
        FILTER_PARAMS = new HashSet<String>();
        FILTER_PARAMS.addAll(ALL_FIELDS);
        FILTER_PARAMS.add("query");
        FILTER_PARAMS.add("text_query");
    }
}

