/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.index;

import io.lucenia.notifications.index.ConfigOperations;
import io.lucenia.notifications.index.ConfigQueryHelper;
import io.lucenia.notifications.model.DocInfo;
import io.lucenia.notifications.model.NotificationConfigDoc;
import io.lucenia.notifications.model.NotificationConfigDocInfo;
import io.lucenia.notifications.settings.PluginSettings;
import io.lucenia.notifications.util.SecureIndexClient;
import io.skylite.ResourceAlreadyExistsException;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentType;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.admin.indices.create.CreateIndexRequest;
import io.skylite.core.action.admin.indices.create.CreateIndexResponse;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.bulk.BulkItemResponse;
import io.skylite.core.action.bulk.BulkResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.get.MultiGetItemResponse;
import io.skylite.core.action.get.MultiGetRequest;
import io.skylite.core.action.get.MultiGetResponse;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.client.metadata.BulkDataObjectRequest;
import io.skylite.core.client.metadata.BulkDataObjectResponse;
import io.skylite.core.client.metadata.DataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectRequest;
import io.skylite.core.client.metadata.DeleteDataObjectResponse;
import io.skylite.core.client.metadata.GetDataObjectRequest;
import io.skylite.core.client.metadata.GetDataObjectResponse;
import io.skylite.core.client.metadata.MetadataClient;
import io.skylite.core.client.metadata.PutDataObjectRequest;
import io.skylite.core.client.metadata.PutDataObjectResponse;
import io.skylite.core.client.metadata.SearchDataObjectRequest;
import io.skylite.core.client.metadata.SearchDataObjectResponse;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.notifications.action.GetNotificationConfigRequest;
import io.skylite.core.notifications.model.NotificationConfigInfo;
import io.skylite.core.notifications.model.NotificationConfigSearchResult;
import io.skylite.core.notifications.model.SearchResults;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.script.Script;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContent;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public final class NotificationConfigIndex
implements ConfigOperations {
    public static final NotificationConfigIndex INSTANCE = new NotificationConfigIndex();
    public static final int DEFAULT_SCHEMA_VERSION = 1;
    public static final String _META = "_meta";
    public static final String SCHEMA_VERSION = "schema_version";
    private static final Logger log = LogManager.getLogger(NotificationConfigIndex.class);
    public static final String INDEX_NAME = ".opensearch-notifications-config";
    private static final String MAPPING_FILE_NAME = "notifications-config-mapping.yml";
    private static final String SETTINGS_FILE_NAME = "notifications-config-settings.yml";
    private static final Map<String, Object> indexMappingAsMap = NotificationConfigIndex.loadIndexMapping();
    private static final int indexMappingSchemaVersion = NotificationConfigIndex.getSchemaVersionFromIndexMapping(indexMappingAsMap);
    private static Client client;
    private static ClusterService clusterService;
    private static MetadataClient metadataClient;
    private static final SearchResults.SearchHitParser<NotificationConfigInfo> searchHitParser;

    private NotificationConfigIndex() {
    }

    private static Map<String, Object> loadIndexMapping() {
        try {
            String mappingContent = NotificationConfigIndex.readResourceFile(MAPPING_FILE_NAME);
            return XContentHelper.convertToMap((XContent)XContentType.YAML.xContent(), (String)mappingContent, (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load index mapping", e);
        }
    }

    private static String readResourceFile(String fileName) throws IOException {
        try (InputStream inputStream = NotificationConfigIndex.class.getClassLoader().getResourceAsStream(fileName);){
            String string;
            if (inputStream == null) {
                throw new IOException("Resource file not found: " + fileName);
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
    }

    public static void initialize(MetadataClient metadataClient, Client client, ClusterService clusterService) {
        NotificationConfigIndex.client = new SecureIndexClient(client);
        NotificationConfigIndex.clusterService = clusterService;
        NotificationConfigIndex.metadataClient = metadataClient;
    }

    private static int getSchemaVersionFromIndexMapping(Map<String, Object> indexMapping) {
        Map metaData;
        int schemaVersion = 1;
        if (indexMapping != null && indexMapping.containsKey(_META) && indexMapping.get(_META) instanceof Map && (metaData = (Map)indexMapping.get(_META)).containsKey(SCHEMA_VERSION)) {
            try {
                schemaVersion = (Integer)metaData.get(SCHEMA_VERSION);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("schema_version can only be Integer");
            }
        }
        return schemaVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createIndex() throws Exception {
        Map currentMapping;
        int currentIndexMappingSchemaVersion;
        if (!NotificationConfigIndex.isIndexExists()) {
            String indexSettingsSource = NotificationConfigIndex.readResourceFile(SETTINGS_FILE_NAME);
            CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME).mapping(indexMappingAsMap).settings(indexSettingsSource, (MediaType)XContentType.YAML);
            try (ThreadContext.StoredContext ignored = client.threadPool().getThreadContext().stashContext();){
                try {
                    CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(request).actionGet(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS);
                    if (!response.isAcknowledged()) throw new IllegalStateException("notifications-core:Index .opensearch-notifications-config creation not Acknowledged");
                    log.info("{}:Index {} creation Acknowledged", (Object)"notifications-core", (Object)INDEX_NAME);
                    return;
                }
                catch (Exception exception) {
                    if (exception instanceof ResourceAlreadyExistsException || exception.getCause() instanceof ResourceAlreadyExistsException) return;
                    throw exception;
                }
            }
        }
        IndexMetadata currentIndexMappingMetadata = (IndexMetadata)clusterService.state().metadata().indices().get(INDEX_NAME);
        if (currentIndexMappingMetadata == null || currentIndexMappingMetadata.mapping() == null || (currentIndexMappingSchemaVersion = NotificationConfigIndex.getSchemaVersionFromIndexMapping(currentMapping = currentIndexMappingMetadata.mapping().sourceAsMap())) >= indexMappingSchemaVersion) return;
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{INDEX_NAME}).source(indexMappingAsMap);
        try (ThreadContext.StoredContext ignored = client.threadPool().getThreadContext().stashContext();){
            AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().putMapping(putMappingRequest).actionGet(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS);
            if (!response.isAcknowledged()) throw new IllegalStateException("notifications-core:Index .opensearch-notifications-config update mapping not Acknowledged");
            log.info("{}:Index {} update mapping Acknowledged", (Object)"notifications-core", (Object)INDEX_NAME);
            return;
        }
    }

    private static boolean isIndexExists() {
        ClusterState clusterState = clusterService.state();
        return clusterState.routingTable().hasIndex(INDEX_NAME);
    }

    @Override
    public String createNotificationConfig(NotificationConfigDoc configDoc, String id) throws Exception {
        NotificationConfigIndex.createIndex();
        PutDataObjectRequest.Builder postRequest = ((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(INDEX_NAME)).dataObject((builder, params) -> configDoc.toXContent(builder, params)).overwriteIfExists(false);
        if (id != null) {
            postRequest.id(id);
        }
        try {
            IndexResponse response = ((PutDataObjectResponse)metadataClient.putDataObjectAsync(postRequest.build()).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).indexResponse();
            if (response.getResult() != DocWriteResponse.Result.CREATED) {
                log.warn("{}:createNotificationConfig - response:{}", (Object)"notifications-core", (Object)response);
                return null;
            }
            return response.getId();
        }
        catch (ExecutionException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof VersionConflictEngineException)) continue;
                throw (VersionConflictEngineException)cause;
            }
            throw new Exception("Failed to create notification config", e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new Exception("Failed to create notification config", e);
        }
    }

    @Override
    public List<NotificationConfigDocInfo> getNotificationConfigs(Set<String> ids) throws Exception {
        NotificationConfigIndex.createIndex();
        MultiGetRequest getRequest = new MultiGetRequest();
        for (String id : ids) {
            getRequest.add(INDEX_NAME, id);
        }
        MultiGetResponse response = (MultiGetResponse)client.multiGet(getRequest).actionGet(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS);
        ArrayList<NotificationConfigDocInfo> result = new ArrayList<NotificationConfigDocInfo>();
        for (MultiGetItemResponse item : response.getResponses()) {
            NotificationConfigDocInfo docInfo = NotificationConfigIndex.parseNotificationConfigDoc(item.getId(), item.getResponse());
            if (docInfo == null) continue;
            result.add(docInfo);
        }
        return result;
    }

    @Override
    public NotificationConfigDocInfo getNotificationConfig(String id) throws Exception {
        NotificationConfigIndex.createIndex();
        GetDataObjectRequest getRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(INDEX_NAME)).id(id)).build();
        try {
            GetResponse response = ((GetDataObjectResponse)metadataClient.getDataObjectAsync(getRequest).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).getResponse();
            return NotificationConfigIndex.parseNotificationConfigDoc(id, response);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Exception("Failed to get notification config", e);
        }
    }

    private static NotificationConfigDocInfo parseNotificationConfigDoc(String id, GetResponse response) {
        if (response == null || response.getSourceAsString() == null) {
            log.warn("{}:getNotificationConfig - {} not found; response:{}", (Object)"notifications-core", (Object)id, (Object)response);
            return null;
        }
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            NotificationConfigDoc doc = NotificationConfigDoc.parse(parser);
            DocInfo info = new DocInfo(id, response.getVersion(), response.getSeqNo(), response.getPrimaryTerm());
            return new NotificationConfigDocInfo(info, doc);
        }
        catch (IOException e) {
            log.error("{}:Failed to parse notification config doc {} {}", (Object)"notifications-core", (Object)id, (Object)e);
            return null;
        }
    }

    @Override
    public NotificationConfigSearchResult getAllNotificationConfigs(List<String> access, GetNotificationConfigRequest request) throws Exception {
        NotificationConfigIndex.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort(ConfigQueryHelper.getSortField(request.getSortField()), request.getSortOrder() != null ? request.getSortOrder() : SortOrder.ASC).size(request.getMaxItems()).from(request.getFromIndex());
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        if (!access.isEmpty()) {
            BoolQueryBuilder filterQuery = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"metadata.access", access)).should((QueryBuilder)QueryBuilders.scriptQuery((Script)new Script("doc['metadata.access'] == []")));
            query.filter((QueryBuilder)filterQuery);
        }
        ConfigQueryHelper.addQueryFilters(query, request.getFilterParams());
        sourceBuilder.query((QueryBuilder)query);
        SearchDataObjectRequest searchRequest = SearchDataObjectRequest.builder().indices(new String[]{INDEX_NAME}).searchSourceBuilder(sourceBuilder).build();
        try {
            SearchResponse response = ((SearchDataObjectResponse)metadataClient.searchDataObjectAsync(searchRequest).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).searchResponse();
            NotificationConfigSearchResult result = new NotificationConfigSearchResult((long)request.getFromIndex(), response, searchHitParser);
            log.info("{}:getAllNotificationConfigs from:{}, maxItems:{}, sortField:{}, sortOrder={}, filters={} retCount:{}, totalCount:{}", (Object)"notifications-core", (Object)request.getFromIndex(), (Object)request.getMaxItems(), (Object)request.getSortField(), (Object)request.getSortOrder(), (Object)request.getFilterParams(), (Object)result.getObjectList().size(), (Object)result.getTotalHits());
            return result;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Exception("Failed to get all notification configs", e);
        }
    }

    @Override
    public boolean updateNotificationConfig(String id, NotificationConfigDoc notificationConfigDoc) throws Exception {
        NotificationConfigIndex.createIndex();
        PutDataObjectRequest putRequest = ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(INDEX_NAME)).id(id)).dataObject((builder, params) -> notificationConfigDoc.toXContent(builder, params)).overwriteIfExists(true).build();
        try {
            IndexResponse response = ((PutDataObjectResponse)metadataClient.putDataObjectAsync(putRequest).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).indexResponse();
            if (response.getResult() != DocWriteResponse.Result.UPDATED) {
                log.warn("{}:updateNotificationConfig failed for {}; response:{}", (Object)"notifications-core", (Object)id, (Object)response);
            }
            return response.getResult() == DocWriteResponse.Result.UPDATED;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Exception("Failed to update notification config", e);
        }
    }

    @Override
    public boolean deleteNotificationConfig(String id) throws Exception {
        NotificationConfigIndex.createIndex();
        DeleteDataObjectRequest deleteRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(INDEX_NAME)).id(id)).build();
        try {
            DeleteResponse response = ((DeleteDataObjectResponse)metadataClient.deleteDataObjectAsync(deleteRequest).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).deleteResponse();
            if (response.getResult() != DocWriteResponse.Result.DELETED) {
                log.warn("{}:deleteNotificationConfig failed for {}; response:{}", (Object)"notifications-core", (Object)id, (Object)response);
            }
            return response.getResult() == DocWriteResponse.Result.DELETED;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Exception("Failed to delete notification config", e);
        }
    }

    @Override
    public Map<String, RestStatus> deleteNotificationConfigs(Set<String> ids) throws Exception {
        NotificationConfigIndex.createIndex();
        BulkDataObjectRequest bulkDeleteRequest = BulkDataObjectRequest.builder().globalIndex(INDEX_NAME).build();
        for (String id : ids) {
            bulkDeleteRequest.add((DataObjectRequest)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(INDEX_NAME)).id(id)).build());
        }
        try {
            BulkResponse response = ((BulkDataObjectResponse)metadataClient.bulkDataObjectAsync(bulkDeleteRequest).toCompletableFuture().get(PluginSettings.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).bulkResponse();
            HashMap<String, RestStatus> resultMap = new HashMap<String, RestStatus>();
            for (BulkItemResponse item : response) {
                resultMap.put(item.getId(), item.status());
                if (!item.isFailed()) continue;
                log.warn("{}:deleteNotificationConfig failed for {}; response:{}", (Object)"notifications-core", (Object)item.getId(), (Object)item.getFailureMessage());
            }
            return resultMap;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new Exception("Failed to delete notification configs", e);
        }
    }

    static {
        searchHitParser = searchHit -> {
            try {
                XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, searchHit.getSourceAsString());
                parser.nextToken();
                NotificationConfigDoc doc = NotificationConfigDoc.parse(parser);
                return new NotificationConfigInfo(searchHit.getId(), doc.getMetadata().getLastUpdateTime(), doc.getMetadata().getCreatedTime(), doc.getConfig());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse search hit", e);
            }
        };
    }
}

