/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.metrics;

import io.lucenia.notifications.metrics.BasicCounter;
import io.lucenia.notifications.metrics.Counter;
import io.lucenia.notifications.metrics.RollingCounter;
import io.skylite.core.common.Strings;
import java.util.LinkedHashMap;

public enum Metrics {
    REQUEST_TOTAL("request_total", new BasicCounter()),
    REQUEST_INTERVAL_COUNT("request_count", new RollingCounter()),
    REQUEST_SUCCESS("success_count", new RollingCounter()),
    REQUEST_USER_ERROR("failed_request_count_user_error", new RollingCounter()),
    REQUEST_SYSTEM_ERROR("failed_request_count_system_error", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_OS_STATUS_EXCEPTION("exception.os_status", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_OS_SECURITY_EXCEPTION("exception.os_security", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_VERSION_CONFLICT_ENGINE_EXCEPTION("exception.version_conflict_engine", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_INDEX_NOT_FOUND_EXCEPTION("exception.index_not_found", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_INVALID_INDEX_NAME_EXCEPTION("exception.invalid_index_name", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_ILLEGAL_ARGUMENT_EXCEPTION("exception.illegal_argument", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_ILLEGAL_STATE_EXCEPTION("exception.illegal_state", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_IO_EXCEPTION("exception.io", new RollingCounter()),
    NOTIFICATIONS_EXCEPTIONS_INTERNAL_SERVER_ERROR("exception.internal_server_error", new RollingCounter()),
    NOTIFICATIONS_CONFIG_CREATE_TOTAL("notifications_config.create.total", new BasicCounter()),
    NOTIFICATIONS_CONFIG_CREATE_INTERVAL_COUNT("notifications_config.create.count", new RollingCounter()),
    NOTIFICATIONS_CONFIG_CREATE_SYSTEM_ERROR("notifications_config.create.system_error", new RollingCounter()),
    NOTIFICATIONS_CONFIG_UPDATE_TOTAL("notifications_config.update.total", new BasicCounter()),
    NOTIFICATIONS_CONFIG_UPDATE_INTERVAL_COUNT("notifications_config.update.count", new RollingCounter()),
    NOTIFICATIONS_CONFIG_UPDATE_USER_ERROR_INVALID_CONFIG_ID("notifications_config.update.user_error.invalid_config_id", new RollingCounter()),
    NOTIFICATIONS_CONFIG_UPDATE_SYSTEM_ERROR("notifications_config.update.system_error", new RollingCounter()),
    NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_ACCOUNT_ID("notifications_config.user_error.invalid_email_account_id", new RollingCounter()),
    NOTIFICATIONS_CONFIG_USER_ERROR_INVALID_EMAIL_GROUP_ID("notifications_config.user_error.invalid_email_group_id", new RollingCounter()),
    NOTIFICATIONS_CONFIG_USER_ERROR_NEITHER_EMAIL_NOR_GROUP("notifications_config.user_error.neither_email_nor_group", new RollingCounter()),
    NOTIFICATIONS_CONFIG_DELETE_TOTAL("notifications_config.delete.total", new BasicCounter()),
    NOTIFICATIONS_CONFIG_DELETE_INTERVAL_COUNT("notifications_config.delete.count", new RollingCounter()),
    NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_INVALID_CONFIG_ID("notifications_config.delete.user_error.invalid_config_id", new RollingCounter()),
    NOTIFICATIONS_CONFIG_DELETE_USER_ERROR_SET_NOT_FOUND("notifications_config.delete.user_error.set_not_found", new RollingCounter()),
    NOTIFICATIONS_CONFIG_DELETE_SYSTEM_ERROR("notifications_config.delete.system_error", new RollingCounter()),
    NOTIFICATIONS_CONFIG_INFO_TOTAL("notifications_config.info.total", new BasicCounter()),
    NOTIFICATIONS_CONFIG_INFO_INTERVAL_COUNT("notifications_config.info.count", new RollingCounter()),
    NOTIFICATIONS_CONFIG_INFO_USER_ERROR_INVALID_CONFIG_ID("notifications_config.info.user_error.invalid_config_id", new RollingCounter()),
    NOTIFICATIONS_CONFIG_INFO_USER_ERROR_SET_NOT_FOUND("notifications_config.info.user_error.set_not_found", new RollingCounter()),
    NOTIFICATIONS_CHANNELS_INFO_TOTAL("notifications_channels.info.total", new BasicCounter()),
    NOTIFICATIONS_CHANNELS_INFO_INTERVAL_COUNT("notifications_channels.info.count", new RollingCounter()),
    NOTIFICATIONS_FEATURES_INFO_TOTAL("notifications_features.info.total", new BasicCounter()),
    NOTIFICATIONS_FEATURES_INFO_INTERVAL_COUNT("notifications_features.info.count", new RollingCounter()),
    NOTIFICATIONS_SEND_MESSAGE_TOTAL("notifications.send_message.total", new BasicCounter()),
    NOTIFICATIONS_SEND_MESSAGE_INTERVAL_COUNT("notifications.send_message.count", new RollingCounter()),
    NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND("notifications.send_message.user_error.not_found", new RollingCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_SLACK("notifications.message_destination.slack", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_CHIME("notifications.message_destination.chime", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_MICROSOFT_TEAMS("notifications.message_destination.microsoft_teams", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_WEBHOOK("notifications.message_destination.webhook", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_EMAIL("notifications.message_destination.email", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_SES_ACCOUNT("notifications.message_destination.ses_account", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_SMTP_ACCOUNT("notifications.message_destination.smtp_account", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_EMAIL_GROUP("notifications.message_destination.email_group", new BasicCounter()),
    NOTIFICATIONS_MESSAGE_DESTINATION_SNS("notifications.message_destination.sns", new BasicCounter()),
    NOTIFICATIONS_SEND_TEST_MESSAGE_TOTAL("notifications.send_test_message.total", new BasicCounter()),
    NOTIFICATIONS_SEND_TEST_MESSAGE_INTERVAL_COUNT("notifications.send_test_message.interval_count", new RollingCounter()),
    NOTIFICATIONS_SECURITY_USER_ERROR("security_user_error", new RollingCounter()),
    NOTIFICATIONS_PERMISSION_USER_ERROR("permissions_user_error", new RollingCounter());

    private final String metricName;
    private final Counter<?> counter;

    private Metrics(String metricName, Counter<?> counter) {
        this.metricName = metricName;
        this.counter = counter;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Counter<?> getCounter() {
        return this.counter;
    }

    private static String collectToJSON() {
        LinkedHashMap<String, Long> metricsMap = new LinkedHashMap<String, Long>();
        for (Metrics metric : Metrics.values()) {
            metricsMap.put(metric.metricName, metric.counter.getValue());
        }
        return Strings.toJson(metricsMap);
    }

    public static String collectToFlattenedJSON() {
        return Strings.unflattenJsonString((String)Metrics.collectToJSON());
    }
}

