/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.model;

import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DocMetadata
implements ToXContent {
    private static final Logger log = LogManager.getLogger(DocMetadata.class);
    public static final String METADATA_TAG = "metadata";
    public static final String ACCESS_LIST_TAG = "access";
    private final Instant lastUpdateTime;
    private final Instant createdTime;
    private final List<String> access;

    public DocMetadata(Instant lastUpdateTime, Instant createdTime, List<String> access) {
        this.lastUpdateTime = lastUpdateTime;
        this.createdTime = createdTime;
        this.access = access != null ? access : new ArrayList();
    }

    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Instant getCreatedTime() {
        return this.createdTime;
    }

    public List<String> getAccess() {
        return this.access;
    }

    public static DocMetadata parse(XContentParser parser) throws IOException {
        Instant lastUpdateTime = null;
        Instant createdTime = null;
        List<String> access = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (XContentParser.Token.END_OBJECT != parser.nextToken()) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "last_updated_time_ms": {
                    lastUpdateTime = Instant.ofEpochMilli(parser.longValue());
                    continue block10;
                }
                case "created_time_ms": {
                    createdTime = Instant.ofEpochMilli(parser.longValue());
                    continue block10;
                }
                case "access": {
                    access = DocMetadata.parseStringList(parser);
                    continue block10;
                }
            }
            parser.skipChildren();
            log.info("DocMetadata Skipping Unknown field {}", (Object)fieldName);
        }
        if (lastUpdateTime == null) {
            throw new IllegalArgumentException("last_updated_time_ms field absent");
        }
        if (createdTime == null) {
            throw new IllegalArgumentException("created_time_ms field absent");
        }
        return new DocMetadata(lastUpdateTime, createdTime, access);
    }

    private static List<String> parseStringList(XContentParser parser) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list.add(parser.text());
        }
        return list;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("last_updated_time_ms", this.lastUpdateTime.toEpochMilli()).field("created_time_ms", this.createdTime.toEpochMilli()).field(ACCESS_LIST_TAG, this.access).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocMetadata that = (DocMetadata)o;
        return Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.createdTime, that.createdTime) && Objects.equals(this.access, that.access);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdateTime, this.createdTime, this.access);
    }

    public String toString() {
        return "DocMetadata{lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", createdTime=" + String.valueOf(this.createdTime) + ", access=" + String.valueOf(this.access) + "}";
    }
}

