/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.resthandler;

import io.lucenia.notifications.metrics.Metrics;
import io.lucenia.notifications.resthandler.PluginBaseHandler;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.GetChannelListRequest;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class NotificationChannelListRestHandler
extends PluginBaseHandler {
    private static final String REQUEST_URL = "/_plugins/_notifications/channels";

    public String getName() {
        return "notifications_channel_list";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, REQUEST_URL));
    }

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer executeRequest(RestRequest request, NodeClient client) {
        if (request.method() == RestRequest.Method.GET) {
            Metrics.NOTIFICATIONS_CHANNELS_INFO_TOTAL.getCounter().increment();
            Metrics.NOTIFICATIONS_CHANNELS_INFO_INTERVAL_COUNT.getCounter().increment();
            return channel -> NotificationsPluginInterface.getChannelList((NodeClient)client, (GetChannelListRequest)new GetChannelListRequest(false), (ActionListener)new RestToXContentListener(channel));
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(request.method()) + " is not allowed"));
    }
}

