/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.resthandler;

import io.lucenia.notifications.index.ConfigQueryHelper;
import io.lucenia.notifications.metrics.Metrics;
import io.lucenia.notifications.resthandler.PluginBaseHandler;
import io.lucenia.notifications.resthandler.RestResponseToXContentListener;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.notifications.NotificationsPluginInterface;
import io.skylite.core.notifications.action.CreateNotificationConfigRequest;
import io.skylite.core.notifications.action.DeleteNotificationConfigRequest;
import io.skylite.core.notifications.action.GetNotificationConfigRequest;
import io.skylite.core.notifications.action.UpdateNotificationConfigRequest;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class NotificationConfigRestHandler
extends PluginBaseHandler {
    private static final Logger log = LogManager.getLogger(NotificationConfigRestHandler.class);
    private static final String REQUEST_URL = "/_plugins/_notifications/configs";

    public String getName() {
        return "notifications_config";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, REQUEST_URL), new RestHandler.Route(RestRequest.Method.PUT, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.DELETE, REQUEST_URL), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_notifications/configs/{config_id}"), new RestHandler.Route(RestRequest.Method.GET, REQUEST_URL));
    }

    protected Set<String> responseParams() {
        return Set.of("config_id", "config_id_list", "sort_field", "sort_order", "from_index", "max_items");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer executeRequest(RestRequest request, NodeClient client) {
        switch (request.method()) {
            case POST: {
                return this.executePostRequest(request, client);
            }
            case PUT: {
                return this.executePutRequest(request, client);
            }
            case DELETE: {
                return this.executeDeleteRequest(request, client);
            }
            case GET: {
                return this.executeGetRequest(request, client);
            }
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(request.method()) + " is not allowed"));
    }

    private BaseRestHandler.RestChannelConsumer executePutRequest(RestRequest request, NodeClient client) {
        return channel -> {
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_TOTAL.getCounter().increment();
            Metrics.NOTIFICATIONS_CONFIG_UPDATE_INTERVAL_COUNT.getCounter().increment();
            try {
                XContentParser parser = request.contentParser();
                parser.nextToken();
                NotificationsPluginInterface.updateNotificationConfig((NodeClient)client, (UpdateNotificationConfigRequest)UpdateNotificationConfigRequest.parse((XContentParser)parser, (String)request.param("config_id")), (ActionListener)new RestToXContentListener(channel));
            }
            catch (IOException e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Failed to parse request: " + e.getMessage()));
            }
        };
    }

    private BaseRestHandler.RestChannelConsumer executePostRequest(RestRequest request, NodeClient client) {
        return channel -> {
            Metrics.NOTIFICATIONS_CONFIG_CREATE_TOTAL.getCounter().increment();
            Metrics.NOTIFICATIONS_CONFIG_CREATE_INTERVAL_COUNT.getCounter().increment();
            try {
                XContentParser parser = request.contentParser();
                parser.nextToken();
                NotificationsPluginInterface.createNotificationConfig((NodeClient)client, (CreateNotificationConfigRequest)CreateNotificationConfigRequest.parse((XContentParser)parser, null), (ActionListener)new RestToXContentListener(channel));
            }
            catch (IOException e) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Failed to parse request: " + e.getMessage()));
            }
        };
    }

    private BaseRestHandler.RestChannelConsumer executeGetRequest(RestRequest request, NodeClient client) {
        Metrics.NOTIFICATIONS_CONFIG_INFO_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_INFO_INTERVAL_COUNT.getCounter().increment();
        String configId = request.param("config_id");
        String configIdList = request.param("config_id_list");
        String sortField = request.param("sort_field");
        String sortOrderString = request.param("sort_order");
        SortOrder sortOrder = sortOrderString != null ? SortOrder.fromString((String)sortOrderString) : null;
        int fromIndex = 0;
        String fromIndexParam = request.param("from_index");
        if (fromIndexParam != null) {
            try {
                fromIndex = Integer.parseInt(fromIndexParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int maxItems = 1000;
        String maxItemsParam = request.param("max_items");
        if (maxItemsParam != null) {
            try {
                maxItems = Integer.parseInt(maxItemsParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Map<String, String> filterParams = request.params().entrySet().stream().filter(entry -> ConfigQueryHelper.FILTER_PARAMS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> request.param((String)entry.getKey())));
        log.info("{}:executeGetRequest from:{}, maxItems:{}, sortField:{}, sortOrder={}, filters={}", (Object)"notifications-core", (Object)fromIndex, (Object)maxItems, (Object)sortField, (Object)sortOrder, filterParams);
        GetNotificationConfigRequest configRequest = new GetNotificationConfigRequest(this.getConfigIdSet(configId, configIdList), fromIndex, maxItems, sortField, sortOrder, filterParams);
        return channel -> NotificationsPluginInterface.getNotificationConfig((NodeClient)client, (GetNotificationConfigRequest)configRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private Set<String> getConfigIdSet(String configId, String configIdList) {
        HashSet<String> retIds = new HashSet<String>();
        if (configId != null) {
            retIds.add(configId);
        }
        if (configIdList != null) {
            retIds.addAll(Arrays.asList(configIdList.split(",")));
        }
        return retIds;
    }

    private BaseRestHandler.RestChannelConsumer executeDeleteRequest(RestRequest request, NodeClient client) {
        String[] stringArray;
        Metrics.NOTIFICATIONS_CONFIG_DELETE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_CONFIG_DELETE_INTERVAL_COUNT.getCounter().increment();
        String configId = request.param("config_id");
        if (configId != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = configId;
        } else {
            stringArray = new String[]{};
        }
        String[] configIdArray = request.paramAsStringArray("config_id_list", stringArray);
        Set configIdSet = Arrays.stream(configIdArray).filter(s -> s != null && !s.isBlank()).collect(Collectors.toSet());
        return channel -> {
            if (configIdSet.isEmpty()) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "either config_id or config_id_list is required"));
            } else {
                NotificationsPluginInterface.deleteNotificationConfig((NodeClient)client, (DeleteNotificationConfigRequest)new DeleteNotificationConfigRequest(configIdSet), new RestResponseToXContentListener((RestChannel)channel));
            }
        };
    }
}

