/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.resthandler;

import io.lucenia.notifications.metrics.Metrics;
import io.skylite.core.notifications.action.BaseResponse;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.XContentBuilder;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestToXContentListener;

public class RestResponseToXContentListener<Response extends BaseResponse>
extends RestToXContentListener<Response> {
    public RestResponseToXContentListener(RestChannel channel) {
        super(channel);
    }

    public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
        super.buildResponse(response, builder);
        Metrics.REQUEST_TOTAL.getCounter().increment();
        Metrics.REQUEST_INTERVAL_COUNT.getCounter().increment();
        RestStatus status = response.getStatus();
        int statusCode = status.getStatus();
        if (statusCode >= RestStatus.OK.getStatus() && statusCode <= RestStatus.MULTI_STATUS.getStatus()) {
            Metrics.REQUEST_SUCCESS.getCounter().increment();
        } else if (status == RestStatus.FORBIDDEN) {
            Metrics.NOTIFICATIONS_SECURITY_USER_ERROR.getCounter().increment();
        } else if (statusCode >= RestStatus.UNAUTHORIZED.getStatus() && statusCode <= RestStatus.TOO_MANY_REQUESTS.getStatus()) {
            Metrics.REQUEST_USER_ERROR.getCounter().increment();
        } else {
            Metrics.REQUEST_SYSTEM_ERROR.getCounter().increment();
        }
        return new BytesRestResponse(this.getStatus(response), builder);
    }

    protected RestStatus getStatus(Response response) {
        return response.getStatus();
    }
}

