/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.resthandler;

import io.lucenia.notifications.action.SendTestNotificationAction;
import io.lucenia.notifications.metrics.Metrics;
import io.lucenia.notifications.model.SendTestNotificationRequest;
import io.lucenia.notifications.resthandler.PluginBaseHandler;
import io.lucenia.notifications.resthandler.RestResponseToXContentListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import java.util.List;
import java.util.Set;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;

public class SendTestMessageRestHandler
extends PluginBaseHandler {
    private static final String REQUEST_URL = "/_plugins/_notifications/feature/test";

    public String getName() {
        return "notifications_send_test";
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.POST, "/_plugins/_notifications/feature/test/{config_id}", RestRequest.Method.GET, "/_plugins/_notifications/feature/test/{config_id}"));
    }

    protected Set<String> responseParams() {
        return Set.of("config_id");
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer executeRequest(RestRequest request, NodeClient client) {
        switch (request.method()) {
            case POST: 
            case GET: {
                return this.executeSendTestMessage(request, client);
            }
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(request.method()) + " is not allowed"));
    }

    private BaseRestHandler.RestChannelConsumer executeSendTestMessage(RestRequest request, NodeClient client) {
        return channel -> {
            Metrics.NOTIFICATIONS_SEND_TEST_MESSAGE_TOTAL.getCounter().increment();
            Metrics.NOTIFICATIONS_SEND_TEST_MESSAGE_INTERVAL_COUNT.getCounter().increment();
            String configId = request.param("config_id");
            SendTestNotificationRequest sendTestNotificationRequest = new SendTestNotificationRequest(configId);
            client.execute(SendTestNotificationAction.ACTION_TYPE, (ActionRequest)sendTestNotificationRequest, new RestResponseToXContentListener((RestChannel)channel));
        };
    }
}

