/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.security;

import io.lucenia.notifications.security.UserAccess;
import io.lucenia.notifications.settings.PluginSettings;
import io.skylite.SkyliteStatusException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import java.util.ArrayList;
import java.util.List;

public final class UserAccessManager
implements UserAccess {
    public static final UserAccessManager INSTANCE = new UserAccessManager();
    public static final String ADMIN_ROLE = "all_access";

    private UserAccessManager() {
    }

    @Override
    public void validateUser(User user) {
        if (PluginSettings.isRbacEnabled() && (user == null || user.getBackendRoles() == null || user.getBackendRoles().isEmpty())) {
            throw new SkyliteStatusException("User doesn't have backend roles configured. Contact administrator.", RestStatus.FORBIDDEN, new Object[0]);
        }
    }

    @Override
    public List<String> getAllAccessInfo(User user) {
        if (user == null) {
            return new ArrayList<String>();
        }
        return user.getBackendRoles();
    }

    @Override
    public List<String> getSearchAccessInfo(User user) {
        if (user == null || !PluginSettings.isRbacEnabled() || user.getRoles() != null && user.getRoles().contains(ADMIN_ROLE)) {
            return new ArrayList<String>();
        }
        return user.getBackendRoles();
    }

    @Override
    public boolean doesUserHaveAccess(User user, List<String> access) {
        if (user == null || !PluginSettings.isRbacEnabled()) {
            return true;
        }
        if (access == null || access.isEmpty()) {
            return true;
        }
        if (user.getRoles() != null && user.getRoles().contains(ADMIN_ROLE)) {
            return true;
        }
        if (user.getBackendRoles() != null) {
            for (String backendRole : user.getBackendRoles()) {
                if (!access.contains(backendRole)) continue;
                return true;
            }
        }
        return false;
    }
}

