/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.send;

import io.lucenia.notifications.CoreProvider;
import io.lucenia.notifications.index.ConfigOperations;
import io.lucenia.notifications.metrics.Metrics;
import io.lucenia.notifications.model.NotificationConfigDocInfo;
import io.lucenia.notifications.security.UserAccess;
import io.skylite.SkyliteStatusException;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.notifications.action.LegacyPublishNotificationRequest;
import io.skylite.core.notifications.action.LegacyPublishNotificationResponse;
import io.skylite.core.notifications.action.SendNotificationRequest;
import io.skylite.core.notifications.action.SendNotificationResponse;
import io.skylite.core.notifications.legacy.destination.message.LegacyBaseMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyCustomWebhookMessage;
import io.skylite.core.notifications.legacy.destination.message.LegacyEmailMessage;
import io.skylite.core.notifications.legacy.destination.response.LegacyDestinationResponse;
import io.skylite.core.notifications.model.BaseConfigData;
import io.skylite.core.notifications.model.ChannelMessage;
import io.skylite.core.notifications.model.Chime;
import io.skylite.core.notifications.model.ConfigType;
import io.skylite.core.notifications.model.DeliveryStatus;
import io.skylite.core.notifications.model.DestinationMessageResponse;
import io.skylite.core.notifications.model.Email;
import io.skylite.core.notifications.model.EmailGroup;
import io.skylite.core.notifications.model.EmailRecipientStatus;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.EventStatus;
import io.skylite.core.notifications.model.MessageContent;
import io.skylite.core.notifications.model.MicrosoftTeams;
import io.skylite.core.notifications.model.NotificationConfig;
import io.skylite.core.notifications.model.NotificationEvent;
import io.skylite.core.notifications.model.SesAccount;
import io.skylite.core.notifications.model.Slack;
import io.skylite.core.notifications.model.SmtpAccount;
import io.skylite.core.notifications.model.Sns;
import io.skylite.core.notifications.model.Webhook;
import io.skylite.core.notifications.model.destination.BaseDestination;
import io.skylite.core.notifications.model.destination.ChimeDestination;
import io.skylite.core.notifications.model.destination.CustomWebhookDestination;
import io.skylite.core.notifications.model.destination.MicrosoftTeamsDestination;
import io.skylite.core.notifications.model.destination.SesDestination;
import io.skylite.core.notifications.model.destination.SlackDestination;
import io.skylite.core.notifications.model.destination.SmtpDestination;
import io.skylite.core.notifications.model.destination.SnsDestination;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SendMessageActionHelper {
    private static final Logger log = LogManager.getLogger(SendMessageActionHelper.class);
    private static ConfigOperations configOperations;
    private static UserAccess userAccess;
    private static final ExecutorService executor;

    private SendMessageActionHelper() {
    }

    public static void initialize(ConfigOperations configOperations, UserAccess userAccess) {
        SendMessageActionHelper.configOperations = configOperations;
        SendMessageActionHelper.userAccess = userAccess;
    }

    public static SendNotificationResponse executeRequest(SendNotificationRequest request) throws Exception {
        EventSource eventSource = request.getEventSource();
        ChannelMessage channelMessage = request.getChannelMessage();
        HashSet<String> channelIds = new HashSet<String>(request.getChannelIds());
        User user = User.parse((String)request.getThreadContext());
        userAccess.validateUser(user);
        Map<String, NotificationConfigDocInfo> channelMap = SendMessageActionHelper.getConfigs(channelIds);
        Set<String> childConfigIds = SendMessageActionHelper.getChildConfigIds(channelMap.values().stream().filter(v -> v != null).collect(Collectors.toList()));
        Map<String, NotificationConfigDocInfo> childConfigMap = SendMessageActionHelper.getConfigs(childConfigIds);
        MessageContent message = SendMessageActionHelper.createMessageContent(eventSource, channelMessage);
        List<EventStatus> eventStatusList = SendMessageActionHelper.sendMessagesInParallel(user, eventSource, channelMap, childConfigMap, message);
        NotificationEvent event = new NotificationEvent(eventSource, eventStatusList);
        String overallStatusCode = eventStatusList.get(0).getDeliveryStatus() != null ? eventStatusList.get(0).getDeliveryStatus().getStatusCode() : null;
        for (EventStatus eventStatus : eventStatusList) {
            if (eventStatus.getDeliveryStatus() == null || eventStatus.getDeliveryStatus().getStatusCode().equals(overallStatusCode)) continue;
            overallStatusCode = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
        }
        String eventStatusListString = eventStatusList.stream().map(SendMessageActionHelper::getJsonString).collect(Collectors.joining(",", "[", "]"));
        if (!String.valueOf(RestStatus.OK.getStatus()).equals(overallStatusCode)) {
            String errorMessage = "{\"event_status_list\": " + eventStatusListString + "}";
            throw new SkyliteStatusException(errorMessage, RestStatus.fromCode((int)Integer.parseInt(overallStatusCode)), new Object[0]);
        }
        return new SendNotificationResponse(event);
    }

    public static LegacyPublishNotificationResponse executeLegacyRequest(LegacyPublishNotificationRequest request) {
        LegacyBaseMessage baseMessage = request.getBaseMessage();
        LegacyDestinationResponse response = SendMessageActionHelper.sendMessageToLegacyDestination(baseMessage);
        return new LegacyPublishNotificationResponse(response);
    }

    private static MessageContent createMessageContent(EventSource eventSource, ChannelMessage channelMessage) {
        return new MessageContent(eventSource.getTitle(), channelMessage.getTextDescription(), channelMessage.getHtmlDescription(), channelMessage.getAttachment() != null ? channelMessage.getAttachment().getFileName() : null, channelMessage.getAttachment() != null ? channelMessage.getAttachment().getFileEncoding() : null, channelMessage.getAttachment() != null ? channelMessage.getAttachment().getFileData() : null, channelMessage.getAttachment() != null ? channelMessage.getAttachment().getFileContentType() : null);
    }

    private static List<EventStatus> sendMessagesInParallel(User user, EventSource eventSource, Map<String, NotificationConfigDocInfo> channelMap, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message) {
        List futures = channelMap.entrySet().stream().map(entry -> CompletableFuture.supplyAsync(() -> SendMessageActionHelper.sendMessageToChannel(user, eventSource, entry, childConfigMap, message), executor)).collect(Collectors.toList());
        return futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
    }

    private static EventStatus sendMessageToChannel(User user, EventSource eventSource, Map.Entry<String, NotificationConfigDocInfo> channelEntry, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message) {
        Metrics.NOTIFICATIONS_SEND_MESSAGE_TOTAL.getCounter().increment();
        Metrics.NOTIFICATIONS_SEND_MESSAGE_INTERVAL_COUNT.getCounter().increment();
        if (channelEntry.getValue() == null) {
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            return new EventStatus(channelEntry.getKey(), "invalid-config", ConfigType.NONE, Collections.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Channel " + channelEntry.getKey() + " not found"));
        }
        if (!userAccess.doesUserHaveAccess(user, channelEntry.getValue().getConfigDoc().getMetadata().getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            return new EventStatus(channelEntry.getKey(), "invalid-access", ConfigType.NONE, Collections.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for channel " + channelEntry.getKey()));
        }
        NotificationConfigDocInfo channel = channelEntry.getValue();
        ConfigType configType = channel.getConfigDoc().getConfig().getConfigType();
        BaseConfigData configData = channel.getConfigDoc().getConfig().getConfigData();
        List<Object> emailRecipientStatus = new ArrayList();
        if (configType == ConfigType.EMAIL) {
            emailRecipientStatus = Collections.singletonList(new EmailRecipientStatus("placeholder@example.com", new DeliveryStatus("Scheduled", "Pending execution")));
        }
        EventStatus eventStatus = new EventStatus(channel.getDocInfo().getId(), channel.getConfigDoc().getConfig().getName(), channel.getConfigDoc().getConfig().getConfigType(), emailRecipientStatus, new DeliveryStatus("Scheduled", "Pending execution"));
        DeliveryStatus invalidStatus = SendMessageActionHelper.getStatusIfChannelIsNotEligibleToSendMessage(channel);
        if (invalidStatus != null) {
            return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, invalidStatus);
        }
        EventStatus response = switch (configType) {
            case ConfigType.SLACK -> SendMessageActionHelper.sendSlackMessage((Slack)configData, message, eventStatus, eventSource.getReferenceId());
            case ConfigType.CHIME -> SendMessageActionHelper.sendChimeMessage((Chime)configData, message, eventStatus, eventSource.getReferenceId());
            case ConfigType.MICROSOFT_TEAMS -> SendMessageActionHelper.sendMicrosoftTeamsMessage((MicrosoftTeams)configData, message, eventStatus, eventSource.getReferenceId());
            case ConfigType.WEBHOOK -> SendMessageActionHelper.sendWebhookMessage((Webhook)configData, message, eventStatus, eventSource.getReferenceId());
            case ConfigType.EMAIL -> SendMessageActionHelper.sendEmailMessage(user, (Email)configData, childConfigMap, message, eventStatus, eventSource.getReferenceId());
            case ConfigType.SNS -> SendMessageActionHelper.sendSNSMessage((Sns)configData, message, eventStatus, eventSource.getReferenceId());
            default -> null;
        };
        if (response == null) {
            log.warn("Cannot send message to destination for config id :{}", (Object)channel.getDocInfo().getId());
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(RestStatus.NOT_FOUND.name(), "Channel not found"));
        }
        return response;
    }

    private static LegacyDestinationResponse sendMessageToLegacyDestination(LegacyBaseMessage baseMessage) {
        MessageContent message = new MessageContent("Legacy Notification", baseMessage.getMessageContent(), null, null, null, null, null);
        if (baseMessage.getChannelType() == null) {
            log.warn("No channel type given (null) for publishing to legacy destination");
            return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(400)).withResponseContent("No channel type given (null) for publishing to legacy destination").build();
        }
        switch (baseMessage.getChannelType()) {
            case LEGACY_SLACK: {
                SlackDestination destination = new SlackDestination(baseMessage.getUrl());
                DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, "legacy");
                return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
            }
            case LEGACY_CHIME: {
                ChimeDestination destination = new ChimeDestination(baseMessage.getUrl());
                DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, "legacy");
                return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
            }
            case LEGACY_CUSTOM_WEBHOOK: {
                LegacyCustomWebhookMessage webhookMessage = (LegacyCustomWebhookMessage)baseMessage;
                CustomWebhookDestination destination = new CustomWebhookDestination(webhookMessage.getUri().toString(), webhookMessage.getHeaderParams(), webhookMessage.getMethod());
                DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, "legacy");
                return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(status.getStatusCode())).withResponseContent(status.getStatusText()).build();
            }
            case LEGACY_EMAIL: {
                LegacyEmailMessage emailMessage = (LegacyEmailMessage)baseMessage;
                List recipients = emailMessage.getRecipients();
                MessageContent emailContent = new MessageContent(emailMessage.getSubject(), emailMessage.getMessageContent(), null, null, null, null, null);
                List futures = recipients.stream().map(recipient -> CompletableFuture.supplyAsync(() -> {
                    SmtpDestination destination = new SmtpDestination(emailMessage.getAccountName(), emailMessage.getHost(), emailMessage.getPort(), emailMessage.getMethod(), emailMessage.getFrom(), recipient);
                    DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, emailContent, "legacy");
                    return new EmailRecipientStatus(recipient, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
                }, executor)).collect(Collectors.toList());
                List emailRecipientStatuses = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
                EmailRecipientStatus firstStatus = (EmailRecipientStatus)emailRecipientStatuses.get(0);
                String overallStatus = firstStatus.getDeliveryStatus().getStatusCode();
                String overallStatusText = firstStatus.getDeliveryStatus().getStatusText();
                for (EmailRecipientStatus recipientStatus : emailRecipientStatuses) {
                    DeliveryStatus status = recipientStatus.getDeliveryStatus();
                    log.info("{}:Legacy email:statusCode={}, statusText={}", (Object)"notifications-core", (Object)status.getStatusCode(), (Object)status.getStatusText());
                    if (overallStatus.equals(status.getStatusCode())) continue;
                    overallStatus = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
                    overallStatusText = "Errors";
                }
                return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(Integer.parseInt(overallStatus))).withResponseContent(overallStatusText).build();
            }
            case LEGACY_SNS: {
                log.warn("Channel type given (sns) for publishing to legacy destination currently not supported");
                return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(400)).withResponseContent("Channel type given (sns) for publishing to legacy destination not supported").build();
            }
        }
        log.warn("Unknown channel type for publishing to legacy destination");
        return new LegacyDestinationResponse.Builder().withStatusCode(Integer.valueOf(400)).withResponseContent("Unknown channel type for publishing to legacy destination").build();
    }

    private static DeliveryStatus getStatusIfChannelIsNotEligibleToSendMessage(NotificationConfigDocInfo channel) {
        if (!channel.getConfigDoc().getConfig().isEnabled()) {
            return new DeliveryStatus(RestStatus.LOCKED.name(), "The channel is muted");
        }
        return null;
    }

    private static EventStatus sendSlackMessage(Slack slack, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SLACK.getCounter().increment();
        SlackDestination destination = new SlackDestination(slack.getUrl());
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EventStatus sendChimeMessage(Chime chime, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_CHIME.getCounter().increment();
        ChimeDestination destination = new ChimeDestination(chime.getUrl());
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EventStatus sendMicrosoftTeamsMessage(MicrosoftTeams microsoftTeams, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_MICROSOFT_TEAMS.getCounter().increment();
        MicrosoftTeamsDestination destination = new MicrosoftTeamsDestination(microsoftTeams.getUrl());
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EventStatus sendWebhookMessage(Webhook webhook, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_WEBHOOK.getCounter().increment();
        CustomWebhookDestination destination = new CustomWebhookDestination(webhook.getUrl(), webhook.getHeaderParams(), webhook.getMethod().getTag());
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EventStatus sendEmailMessage(User user, Email email, Map<String, NotificationConfigDocInfo> childConfigMap, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_EMAIL.getCounter().increment();
        NotificationConfigDocInfo accountDocInfo = childConfigMap.get(email.getEmailAccountID());
        if (accountDocInfo == null) {
            Metrics.NOTIFICATIONS_SEND_MESSAGE_USER_ERROR_NOT_FOUND.getCounter().increment();
            return SendMessageActionHelper.copyEventStatusWithEmailRecipientStatusAndDeliveryStatus(eventStatus, Collections.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Sender " + email.getEmailAccountID() + " not found"));
        }
        if (!userAccess.doesUserHaveAccess(user, accountDocInfo.getConfigDoc().getMetadata().getAccess())) {
            Metrics.NOTIFICATIONS_PERMISSION_USER_ERROR.getCounter().increment();
            return SendMessageActionHelper.copyEventStatusWithEmailRecipientStatusAndDeliveryStatus(eventStatus, Collections.emptyList(), new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for sender " + accountDocInfo.getDocInfo().getId()));
        }
        Set accessDeniedGroupIds = childConfigMap.entrySet().stream().filter(entry -> entry.getValue() != null && !userAccess.doesUserHaveAccess(user, ((NotificationConfigDocInfo)entry.getValue()).getConfigDoc().getMetadata().getAccess())).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set invalidGroupIds = childConfigMap.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
        List groups = childConfigMap.values().stream().filter(v -> v != null).filter(v -> email.getEmailGroupIds().contains(v.getDocInfo().getId()) && !accessDeniedGroupIds.contains(v.getDocInfo().getId())).collect(Collectors.toList());
        Set groupRecipients = groups.stream().flatMap(g -> ((EmailGroup)g.getConfigDoc().getConfig().getConfigData()).getRecipients().stream()).collect(Collectors.toSet());
        HashSet allRecipients = new HashSet(email.getRecipients());
        allRecipients.addAll(groupRecipients);
        NotificationConfig accountConfig = accountDocInfo.getConfigDoc().getConfig();
        List futures = allRecipients.stream().map(recipient -> CompletableFuture.supplyAsync(() -> {
            switch (accountConfig.getConfigType()) {
                case SMTP_ACCOUNT: {
                    return SendMessageActionHelper.sendEmailFromSmtpAccount(accountConfig.getName(), (SmtpAccount)accountConfig.getConfigData(), recipient.getRecipient(), message, referenceId);
                }
                case SES_ACCOUNT: {
                    return SendMessageActionHelper.sendEmailFromSesAccount(accountConfig.getName(), (SesAccount)accountConfig.getConfigData(), recipient.getRecipient(), message, referenceId);
                }
            }
            return new EmailRecipientStatus(recipient.getRecipient(), new DeliveryStatus(RestStatus.NOT_ACCEPTABLE.name(), "email account type not enabled"));
        }, executor)).collect(Collectors.toList());
        List<EmailRecipientStatus> emailRecipientStatusList = futures.stream().map(CompletableFuture::join).collect(Collectors.toList());
        for (String invalidId : invalidGroupIds) {
            emailRecipientStatusList.add(new EmailRecipientStatus("unknown-recipient@example.com", new DeliveryStatus(String.valueOf(RestStatus.NOT_FOUND.getStatus()), "Recipient " + invalidId + " not found")));
        }
        for (String deniedId : accessDeniedGroupIds) {
            emailRecipientStatusList.add(new EmailRecipientStatus("invalid-access@example.com", new DeliveryStatus(String.valueOf(RestStatus.FORBIDDEN.getStatus()), "Access denied for recipient " + deniedId)));
        }
        EmailRecipientStatus firstStatus = (EmailRecipientStatus)emailRecipientStatusList.get(0);
        String overallStatus = firstStatus.getDeliveryStatus().getStatusCode();
        String overallStatusText = firstStatus.getDeliveryStatus().getStatusText();
        for (EmailRecipientStatus recipientStatus : emailRecipientStatusList) {
            DeliveryStatus status = recipientStatus.getDeliveryStatus();
            log.info("{}:{}:statusCode={}, statusText={}", (Object)"notifications-core", (Object)email.getEmailAccountID(), (Object)status.getStatusCode(), (Object)status.getStatusText());
            if (overallStatus.equals(status.getStatusCode())) continue;
            overallStatus = String.valueOf(RestStatus.MULTI_STATUS.getStatus());
            overallStatusText = "Errors";
        }
        return SendMessageActionHelper.copyEventStatusWithEmailRecipientStatusAndDeliveryStatus(eventStatus, emailRecipientStatusList, new DeliveryStatus(overallStatus, overallStatusText));
    }

    private static EmailRecipientStatus sendEmailFromSmtpAccount(String accountName, SmtpAccount smtpAccount, String recipient, MessageContent message, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SMTP_ACCOUNT.getCounter().increment();
        SmtpDestination destination = new SmtpDestination(accountName, smtpAccount.getHost(), smtpAccount.getPort(), smtpAccount.getMethod().getTag(), smtpAccount.getFromAddress(), recipient);
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return new EmailRecipientStatus(recipient, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EmailRecipientStatus sendEmailFromSesAccount(String accountName, SesAccount sesAccount, String recipient, MessageContent message, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SES_ACCOUNT.getCounter().increment();
        SesDestination destination = new SesDestination(accountName, sesAccount.getAwsRegion(), sesAccount.getRoleArn(), sesAccount.getFromAddress(), recipient);
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return new EmailRecipientStatus(recipient, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static EventStatus sendSNSMessage(Sns sns, MessageContent message, EventStatus eventStatus, String referenceId) {
        Metrics.NOTIFICATIONS_MESSAGE_DESTINATION_SNS.getCounter().increment();
        SnsDestination destination = new SnsDestination(sns.getTopicArn(), sns.getRoleArn());
        DestinationMessageResponse status = SendMessageActionHelper.sendMessageThroughSpi((BaseDestination)destination, message, referenceId);
        return SendMessageActionHelper.copyEventStatusWithDeliveryStatus(eventStatus, new DeliveryStatus(String.valueOf(status.getStatusCode()), status.getStatusText()));
    }

    private static DestinationMessageResponse sendMessageThroughSpi(BaseDestination destination, MessageContent message, String referenceId) {
        try {
            DestinationMessageResponse status = CoreProvider.getCore().sendMessage(destination, message, referenceId);
            log.info("{}:sendMessage:statusCode={}, statusText={}", (Object)"notifications-core", (Object)status.getStatusCode(), (Object)status.getStatusText());
            return status;
        }
        catch (Exception exception) {
            log.warn("sendMessage Exception:{}", (Object)exception.toString());
            return new DestinationMessageResponse(RestStatus.FAILED_DEPENDENCY.getStatus(), "Failed to send notification");
        }
    }

    private static Set<String> getChildConfigIds(List<NotificationConfigDocInfo> channels) {
        List emailConfigs = channels.stream().filter(c -> c.getConfigDoc().getConfig().getConfigType() == ConfigType.EMAIL).collect(Collectors.toList());
        if (!emailConfigs.isEmpty()) {
            HashSet<String> childIds = new HashSet<String>();
            for (NotificationConfigDocInfo config : emailConfigs) {
                Email email = (Email)config.getConfigDoc().getConfig().getConfigData();
                childIds.add(email.getEmailAccountID());
                childIds.addAll(email.getEmailGroupIds());
            }
            return childIds;
        }
        return Collections.emptySet();
    }

    private static Map<String, NotificationConfigDocInfo> getConfigs(Set<String> configIds) throws Exception {
        if (configIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (configIds.size() == 1) {
            return SendMessageActionHelper.getSingleConfig(configIds.iterator().next());
        }
        return SendMessageActionHelper.getAllConfigs(configIds);
    }

    private static Map<String, NotificationConfigDocInfo> getAllConfigs(Set<String> configIds) throws Exception {
        log.info("{}:getAllConfigs-get {}", (Object)"notifications-core", configIds);
        List<NotificationConfigDocInfo> configDocs = configOperations.getNotificationConfigs(configIds);
        HashMap<String, NotificationConfigDocInfo> configMap = new HashMap<String, NotificationConfigDocInfo>();
        for (String id : configIds) {
            configMap.put(id, null);
        }
        for (NotificationConfigDocInfo doc : configDocs) {
            configMap.put(doc.getDocInfo().getId(), doc);
        }
        if (configDocs.size() != configIds.size()) {
            Set invalidConfigIds = configMap.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
            log.error("{}:getAllConfigs {} not found", (Object)"notifications-core", invalidConfigIds);
        }
        return configMap;
    }

    private static Map<String, NotificationConfigDocInfo> getSingleConfig(String configId) throws Exception {
        log.info("{}:getSingleConfig-get {}", (Object)"notifications-core", (Object)configId);
        NotificationConfigDocInfo configDoc = configOperations.getNotificationConfig(configId);
        HashMap<String, NotificationConfigDocInfo> result = new HashMap<String, NotificationConfigDocInfo>();
        result.put(configId, configDoc);
        return result;
    }

    private static String getJsonString(ToXContent xContent) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)byteArrayOutputStream);
            xContent.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            string = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Failed to convert to JSON string", (Throwable)e);
                return "{}";
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    private static EventStatus copyEventStatusWithDeliveryStatus(EventStatus original, DeliveryStatus deliveryStatus) {
        return new EventStatus(original.getConfigId(), original.getConfigName(), original.getConfigType(), original.getEmailRecipientStatus(), deliveryStatus);
    }

    private static EventStatus copyEventStatusWithEmailRecipientStatusAndDeliveryStatus(EventStatus original, List<EmailRecipientStatus> emailRecipientStatus, DeliveryStatus deliveryStatus) {
        return new EventStatus(original.getConfigId(), original.getConfigName(), original.getConfigType(), emailRecipientStatus, deliveryStatus);
    }

    static {
        executor = Executors.newCachedThreadPool(SkyliteExecutors.daemonThreadFactory((String)"send-message-helper"));
    }
}

