/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.notifications.settings;

import io.skylite.core.bootstrap.BootstrapInfo;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PluginSettings {
    private static final Logger log;
    public static final String PLUGIN_NAME = "opensearch-notifications";
    public static final String LOG_PREFIX = "notifications";
    private static ClusterService clusterService;
    private static final String KEY_PREFIX = "opensearch.notifications";
    private static final String GENERAL_KEY_PREFIX = "opensearch.notifications.general";
    private static final String OPERATION_TIMEOUT_MS_KEY = "opensearch.notifications.general.operation_timeout_ms";
    private static final String DEFAULT_ITEMS_QUERY_COUNT_KEY = "opensearch.notifications.general.default_items_query_count";
    private static final String LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES_KEY = "opendistro.alerting.filter_by_backend_roles";
    private static final String ALERTING_FILTER_BY_BACKEND_ROLES_KEY = "plugins.alerting.filter_by_backend_roles";
    private static final String FILTER_BY_BACKEND_ROLES_KEY = "opensearch.notifications.general.filter_by_backend_roles";
    private static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private static final long MINIMUM_OPERATION_TIMEOUT_MS = 100L;
    private static final int DEFAULT_ITEMS_QUERY_COUNT_VALUE = 100;
    private static final int MINIMUM_ITEMS_QUERY_COUNT = 10;
    private static volatile long operationTimeoutMs;
    private static volatile int defaultItemsQueryCount;
    private static final int DECIMAL_RADIX = 10;
    private static final Map<String, String> defaultSettings;
    public static final Setting<Long> OPERATION_TIMEOUT_MS;
    public static final Setting<Integer> DEFAULT_ITEMS_QUERY_COUNT;
    public static final Setting<Boolean> LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES;
    public static final Setting<Boolean> ALERTING_FILTER_BY_BACKEND_ROLES;
    public static final Setting<Boolean> FILTER_BY_BACKEND_ROLES;
    public static final Setting<String> REMOTE_METADATA_STORE_TYPE;
    public static final Setting<String> REMOTE_METADATA_ENDPOINT;
    public static final Setting<String> REMOTE_METADATA_REGION;
    public static final Setting<String> REMOTE_METADATA_SERVICE_NAME;

    private PluginSettings() {
    }

    public static long getOperationTimeoutMs() {
        return operationTimeoutMs;
    }

    public static int getDefaultItemsQueryCount() {
        return defaultItemsQueryCount;
    }

    public static boolean isRbacEnabled() {
        if (clusterService != null && clusterService.getClusterSettings().get(FILTER_BY_BACKEND_ROLES_KEY) != null) {
            Boolean value = (Boolean)clusterService.getClusterSettings().get(FILTER_BY_BACKEND_ROLES);
            return value != null && value != false;
        }
        return false;
    }

    public static List<Setting<?>> getAllSettings() {
        return Arrays.asList(OPERATION_TIMEOUT_MS, DEFAULT_ITEMS_QUERY_COUNT, FILTER_BY_BACKEND_ROLES, REMOTE_METADATA_REGION, REMOTE_METADATA_ENDPOINT, REMOTE_METADATA_STORE_TYPE, REMOTE_METADATA_SERVICE_NAME);
    }

    private static void updateSettingValuesFromLocal(ClusterService clusterService) {
        operationTimeoutMs = (Long)OPERATION_TIMEOUT_MS.get(clusterService.getSettings());
        defaultItemsQueryCount = (Integer)DEFAULT_ITEMS_QUERY_COUNT.get(clusterService.getSettings());
    }

    private static void updateSettingValuesFromCluster(ClusterService clusterService) {
        Integer clusterDefaultItemsQueryCount;
        Long clusterOperationTimeoutMs = (Long)clusterService.getClusterSettings().get(OPERATION_TIMEOUT_MS);
        if (clusterOperationTimeoutMs != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)LOG_PREFIX, (Object)OPERATION_TIMEOUT_MS_KEY, (Object)clusterOperationTimeoutMs);
            operationTimeoutMs = clusterOperationTimeoutMs;
        }
        if ((clusterDefaultItemsQueryCount = (Integer)clusterService.getClusterSettings().get(DEFAULT_ITEMS_QUERY_COUNT)) != null) {
            log.debug("{}:{} -autoUpdatedTo-> {}", (Object)LOG_PREFIX, (Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, (Object)clusterDefaultItemsQueryCount);
            defaultItemsQueryCount = clusterDefaultItemsQueryCount;
        }
    }

    public static void addSettingsUpdateConsumer(ClusterService clusterService) {
        PluginSettings.clusterService = clusterService;
        PluginSettings.updateSettingValuesFromLocal(clusterService);
        PluginSettings.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OPERATION_TIMEOUT_MS, value -> {
            operationTimeoutMs = value;
            log.info("{}:{} -updatedTo-> {}", (Object)LOG_PREFIX, (Object)OPERATION_TIMEOUT_MS_KEY, value);
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ITEMS_QUERY_COUNT, value -> {
            defaultItemsQueryCount = value;
            log.info("{}:{} -updatedTo-> {}", (Object)LOG_PREFIX, (Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, value);
        });
    }

    public static void reset() {
        operationTimeoutMs = 60000L;
        defaultItemsQueryCount = 100;
    }

    static {
        Object configDirName;
        log = LogManager.getLogger(PluginSettings.class);
        Settings settings = null;
        Object object = configDirName = BootstrapInfo.getSystemProperties() != null ? (Object)BootstrapInfo.getSystemProperties().get("opensearch.path.conf") : null;
        if (configDirName != null) {
            Path defaultSettingYmlFile = Path.of(configDirName.toString(), PLUGIN_NAME, "notifications.yml");
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                log.warn("{}:Failed to load {}:{}", (Object)LOG_PREFIX, (Object)defaultSettingYmlFile.toAbsolutePath(), (Object)e.getMessage());
            }
        }
        operationTimeoutMs = settings != null && settings.get(OPERATION_TIMEOUT_MS_KEY) != null ? Long.parseLong(settings.get(OPERATION_TIMEOUT_MS_KEY)) : 60000L;
        defaultItemsQueryCount = settings != null && settings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY) != null ? Integer.parseInt(settings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)) : 100;
        defaultSettings = new HashMap<String, String>();
        defaultSettings.put(OPERATION_TIMEOUT_MS_KEY, Long.toString(operationTimeoutMs, 10));
        defaultSettings.put(DEFAULT_ITEMS_QUERY_COUNT_KEY, Integer.toString(defaultItemsQueryCount, 10));
        OPERATION_TIMEOUT_MS = Setting.longSetting((String)OPERATION_TIMEOUT_MS_KEY, (long)Long.parseLong(defaultSettings.get(OPERATION_TIMEOUT_MS_KEY)), (long)100L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        DEFAULT_ITEMS_QUERY_COUNT = Setting.intSetting((String)DEFAULT_ITEMS_QUERY_COUNT_KEY, (int)Integer.parseInt(defaultSettings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)), (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES = Setting.boolSetting((String)LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES_KEY, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
        ALERTING_FILTER_BY_BACKEND_ROLES = Setting.boolSetting((String)ALERTING_FILTER_BY_BACKEND_ROLES_KEY, LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        FILTER_BY_BACKEND_ROLES = Setting.boolSetting((String)FILTER_BY_BACKEND_ROLES_KEY, ALERTING_FILTER_BY_BACKEND_ROLES, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
        REMOTE_METADATA_STORE_TYPE = Setting.simpleString((String)"plugins.alerting.remote_metadata_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
        REMOTE_METADATA_ENDPOINT = Setting.simpleString((String)"plugins.alerting.remote_metadata_endpoint", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
        REMOTE_METADATA_REGION = Setting.simpleString((String)"plugins.alerting.remote_metadata_region", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
        REMOTE_METADATA_SERVICE_NAME = Setting.simpleString((String)"plugins.alerting.remote_metadata_service_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final});
    }
}

