/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.plugins;

import io.lucenia.cli.EnvironmentAwareCommand;
import io.skylite.Version;
import io.skylite.cli.Terminal;
import io.skylite.core.env.Environment;
import io.skylite.core.plugins.PluginInfo;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed lucenia plugins");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(env.pluginsDir(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + String.valueOf(env.pluginsDir()));
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Plugins directory: " + String.valueOf(env.pluginsDir()));
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsDir());){
            for (Path plugin : paths) {
                plugins.add(plugin);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            this.printPlugin(env, terminal, plugin, "");
        }
    }

    private void printPlugin(Environment env, Terminal terminal, Path plugin, String prefix) throws IOException {
        PluginInfo info = PluginInfo.readFromProperties((Path)env.pluginsDir().resolve(plugin));
        terminal.println(Terminal.Verbosity.SILENT, prefix + info.getName());
        terminal.println(Terminal.Verbosity.VERBOSE, info.toString(prefix));
        if (!info.getLuceniaVersion().equals((Object)Version.CURRENT)) {
            terminal.errorPrintln("WARNING: plugin [" + info.getName() + "] was built for Lucenia version " + info.getVersion() + " but version " + String.valueOf(Version.CURRENT) + " is required");
        }
    }
}

