/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import com.google.auth.oauth2.ServiceAccountCredentials;
import io.lucenia.repositories.gcs.ProxySettings;
import io.lucenia.repositories.gcs.SocketAccess;
import io.skylite.common.SecureString;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Strings;
import io.skylite.core.settings.SecureSetting;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class GoogleCloudStorageClientSettings {
    private static final String PREFIX = "gcs.client.";
    static final Setting.AffixSetting<InputStream> CREDENTIALS_FILE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"credentials_file", key -> SecureSetting.secureFile((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> ENDPOINT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"endpoint", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> PROJECT_ID_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"project_id", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<URI> TOKEN_URI_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"token_uri", key -> new Setting(key, "", URI::create, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<TimeValue> CONNECT_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.ZERO, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> APPLICATION_NAME_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"application_name", key -> new Setting(key, "repository-gcs", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<Proxy.Type> PROXY_TYPE_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"proxy.type", key -> new Setting(key, Proxy.Type.DIRECT.name(), s -> Proxy.Type.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    static final Setting.AffixSetting<String> PROXY_HOST_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> PROXY_TYPE_SETTING});
    static final Setting.AffixSetting<Integer> PROXY_PORT_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"proxy.port", key -> Setting.intSetting((String)key, (int)0, (int)0, (int)65535, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING});
    static final Setting.AffixSetting<SecureString> PROXY_USERNAME_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"proxy.username", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING});
    static final Setting.AffixSetting<SecureString> PROXY_PASSWORD_SETTING = Setting.affixKeySetting((String)"gcs.client.", (String)"proxy.password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{() -> PROXY_TYPE_SETTING, () -> PROXY_HOST_SETTING, () -> PROXY_USERNAME_SETTING});
    private final ServiceAccountCredentials credential;
    private final String endpoint;
    private final String projectId;
    private final TimeValue connectTimeout;
    private final TimeValue readTimeout;
    private final String applicationName;
    private final URI tokenUri;
    private final ProxySettings proxySettings;

    GoogleCloudStorageClientSettings(ServiceAccountCredentials credential, String endpoint, String projectId, TimeValue connectTimeout, TimeValue readTimeout, String applicationName, URI tokenUri, ProxySettings proxySettings) {
        this.credential = credential;
        this.endpoint = endpoint;
        this.projectId = projectId;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.applicationName = applicationName;
        this.tokenUri = tokenUri;
        this.proxySettings = proxySettings;
    }

    public ServiceAccountCredentials getCredential() {
        return this.credential;
    }

    public String getHost() {
        return this.endpoint;
    }

    public String getProjectId() {
        return Strings.hasLength((String)this.projectId) ? this.projectId : (this.credential != null ? this.credential.getProjectId() : null);
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public TimeValue getReadTimeout() {
        return this.readTimeout;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public URI getTokenUri() {
        return this.tokenUri;
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    public static Map<String, GoogleCloudStorageClientSettings> load(Settings settings) {
        HashMap<String, GoogleCloudStorageClientSettings> clients = new HashMap<String, GoogleCloudStorageClientSettings>();
        for (String clientName : settings.getGroups(PREFIX).keySet()) {
            clients.put(clientName, GoogleCloudStorageClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", GoogleCloudStorageClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    static GoogleCloudStorageClientSettings getClientSettings(Settings settings, String clientName) {
        return new GoogleCloudStorageClientSettings(GoogleCloudStorageClientSettings.loadCredential(settings, clientName), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, ENDPOINT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROJECT_ID_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, CONNECT_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, READ_TIMEOUT_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, APPLICATION_NAME_SETTING), GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, TOKEN_URI_SETTING), GoogleCloudStorageClientSettings.validateAndCreateProxySettings(settings, clientName));
    }

    static ProxySettings validateAndCreateProxySettings(Settings settings, String clientName) {
        Proxy.Type proxyType = GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROXY_TYPE_SETTING);
        String proxyHost = GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROXY_HOST_SETTING);
        int proxyPort = GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROXY_PORT_SETTING);
        SecureString proxyUserName = GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROXY_USERNAME_SETTING);
        SecureString proxyPassword = GoogleCloudStorageClientSettings.getConfigValue(settings, clientName, PROXY_PASSWORD_SETTING);
        if (proxyType == Proxy.Type.DIRECT && (proxyPort != 0 || Strings.hasText((String)proxyHost) || Strings.hasText((CharSequence)proxyUserName) || Strings.hasText((CharSequence)proxyPassword))) {
            throw new SettingsException("Google Cloud Storage proxy port or host or username or password have been set but proxy type is not defined.");
        }
        if (proxyType != Proxy.Type.DIRECT && (proxyPort == 0 || Strings.isEmpty((CharSequence)proxyHost))) {
            throw new SettingsException("Google Cloud Storage proxy type has been set but proxy host or port is not defined.");
        }
        if (proxyType == Proxy.Type.DIRECT) {
            return ProxySettings.NO_PROXY_SETTINGS;
        }
        try {
            InetAddress proxyHostAddress = InetAddress.getByName(proxyHost);
            return new ProxySettings(proxyType, proxyHostAddress, proxyPort, proxyUserName.toString(), proxyPassword.toString());
        }
        catch (UnknownHostException e) {
            throw new SettingsException("Google Cloud Storage proxy host is unknown.", (Throwable)e);
        }
    }

    static ServiceAccountCredentials loadCredential(Settings settings, String clientName) {
        ServiceAccountCredentials serviceAccountCredentials;
        block9: {
            if (!CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName).exists(settings)) {
                return null;
            }
            InputStream credStream = (InputStream)CREDENTIALS_FILE_SETTING.getConcreteSettingForNamespace(clientName).get(settings);
            try {
                Set<String> scopes = Collections.singleton("https://www.googleapis.com/auth/devstorage.full_control");
                serviceAccountCredentials = SocketAccess.doPrivilegedIOException(() -> {
                    ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)credStream);
                    if (credentials.createScopedRequired()) {
                        return (ServiceAccountCredentials)credentials.createScoped(scopes);
                    }
                    return credentials;
                });
                if (credStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (credStream != null) {
                        try {
                            credStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            credStream.close();
        }
        return serviceAccountCredentials;
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }
}

