/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import io.lucenia.repositories.gcs.GoogleCloudStorageBlobStore;
import io.lucenia.repositories.gcs.GoogleCloudStorageService;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.cluster.metadata.RepositoryMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.Strings;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.repositories.RepositoryException;
import io.skylite.core.repositories.blobstore.MeteredBlobStoreRepository;
import io.skylite.core.settings.Setting;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class GoogleCloudStorageRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageRepository.class);
    static final ByteSizeValue MIN_CHUNK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.BYTES);
    static final ByteSizeValue MAX_CHUNK_SIZE = new ByteSizeValue(5L, ByteSizeUnit.TB);
    static final String TYPE = "gcs";
    static final Setting<String> BUCKET = Setting.simpleString((String)"bucket", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> BASE_PATH = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<ByteSizeValue> CHUNK_SIZE = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)MAX_CHUNK_SIZE, (ByteSizeValue)MIN_CHUNK_SIZE, (ByteSizeValue)MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    static final Setting<String> CLIENT_NAME = new Setting("client", "default", Function.identity(), new Setting.Property[0]);
    private final GoogleCloudStorageService storageService;
    private final BlobPath basePath;
    private final ByteSizeValue chunkSize;
    private final String bucket;
    private final String clientName;

    GoogleCloudStorageRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, GoogleCloudStorageService storageService, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, namedXContentRegistry, clusterService, recoverySettings, GoogleCloudStorageRepository.buildLocation(metadata));
        this.storageService = storageService;
        String basePath = (String)BASE_PATH.get(metadata.settings());
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
        this.chunkSize = GoogleCloudStorageRepository.getSetting(CHUNK_SIZE, metadata);
        this.bucket = GoogleCloudStorageRepository.getSetting(BUCKET, metadata);
        this.clientName = (String)CLIENT_NAME.get(metadata.settings());
        logger.debug("using bucket [{}], base_path [{}], chunk_size [{}], compress [{}]", (Object)this.bucket, (Object)basePath, (Object)this.chunkSize, (Object)this.isCompress());
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return Map.of("base_path", (String)BASE_PATH.get(metadata.settings()), "bucket", GoogleCloudStorageRepository.getSetting(BUCKET, metadata));
    }

    protected GoogleCloudStorageBlobStore createBlobStore() {
        return new GoogleCloudStorageBlobStore(this.bucket, this.clientName, this.metadata.name(), this.storageService, this.bufferSize);
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public List<Setting<?>> getRestrictedSystemRepositorySettings() {
        ArrayList restrictedSettings = new ArrayList();
        restrictedSettings.addAll(super.getRestrictedSystemRepositorySettings());
        restrictedSettings.add(BUCKET);
        restrictedSettings.add(BASE_PATH);
        return restrictedSettings;
    }

    static <T> T getSetting(Setting<T> setting, RepositoryMetadata metadata) {
        Object value = setting.get(metadata.settings());
        if (value == null) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is not defined for repository");
        }
        if (value instanceof String && !Strings.hasText((String)((String)value))) {
            throw new RepositoryException(metadata.name(), "Setting [" + setting.getKey() + "] is empty for repository");
        }
        return (T)value;
    }
}

