/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import io.lucenia.repositories.gcs.GoogleCloudStorageClientSettings;
import io.lucenia.repositories.gcs.GoogleCloudStorageHttpStatsCollector;
import io.lucenia.repositories.gcs.GoogleCloudStorageOperationsStats;
import io.lucenia.repositories.gcs.ProxySettings;
import io.lucenia.repositories.gcs.SocketAccess;
import io.skylite.common.collect.MapBuilder;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.Strings;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private volatile Map<String, GoogleCloudStorageClientSettings> clientSettings = Collections.emptyMap();
    private volatile Map<String, Storage> clientCache = Collections.emptyMap();

    public synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        this.clientCache = Collections.emptyMap();
        this.clientSettings = MapBuilder.newMapBuilder(clientsSettings).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storage client(String clientName, String repositoryName, GoogleCloudStorageOperationsStats stats) throws IOException {
        Storage storage = this.clientCache.get(repositoryName);
        if (storage != null) {
            return storage;
        }
        GoogleCloudStorageService googleCloudStorageService = this;
        synchronized (googleCloudStorageService) {
            Storage existing = this.clientCache.get(repositoryName);
            if (existing != null) {
                return existing;
            }
            GoogleCloudStorageClientSettings settings = this.clientSettings.get(clientName);
            if (settings == null) {
                throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + Strings.collectionToDelimitedString(this.clientSettings.keySet(), (String)","));
            }
            logger.debug(() -> new ParameterizedMessage("creating GCS client with client_name [{}], endpoint [{}]", (Object)clientName, (Object)settings.getHost()));
            Storage storage2 = this.createClient(settings, stats);
            this.clientCache = MapBuilder.newMapBuilder(this.clientCache).put((Object)repositoryName, (Object)storage2).immutableMap();
            return storage2;
        }
    }

    synchronized void closeRepositoryClient(String repositoryName) {
        this.clientCache = MapBuilder.newMapBuilder(this.clientCache).remove((Object)repositoryName).immutableMap();
    }

    private Storage createClient(GoogleCloudStorageClientSettings clientSettings, GoogleCloudStorageOperationsStats stats) throws IOException {
        HttpTransport httpTransport = this.createHttpTransport(clientSettings);
        final GoogleCloudStorageHttpStatsCollector httpStatsCollector = new GoogleCloudStorageHttpStatsCollector(stats);
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(clientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> httpTransport)){

            public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
                HttpRequestInitializer requestInitializer = super.getHttpRequestInitializer(serviceOptions);
                return httpRequest -> {
                    if (requestInitializer != null) {
                        requestInitializer.initialize(httpRequest);
                    }
                    httpRequest.setResponseInterceptor((HttpResponseInterceptor)httpStatsCollector);
                };
            }
        };
        StorageOptions storageOptions = this.createStorageOptions(clientSettings, httpTransportOptions);
        return (Storage)storageOptions.getService();
    }

    private HttpTransport createHttpTransport(GoogleCloudStorageClientSettings clientSettings) throws IOException {
        return (HttpTransport)SocketAccess.doPrivilegedIOException(() -> {
            NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
            builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
            final ProxySettings proxySettings = clientSettings.getProxySettings();
            if (proxySettings != ProxySettings.NO_PROXY_SETTINGS) {
                if (proxySettings.isAuthenticated()) {
                    Authenticator.setDefault(new Authenticator(this){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(proxySettings.getUsername(), proxySettings.getPassword().toCharArray());
                        }
                    });
                }
                builder.setProxy(new Proxy(proxySettings.getType(), proxySettings.getAddress()));
            }
            return builder.build();
        });
    }

    StorageOptions createStorageOptions(GoogleCloudStorageClientSettings clientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)StorageOptions.newBuilder().setTransportOptions((TransportOptions)httpTransportOptions).setHeaderProvider(() -> {
            MapBuilder mapBuilder = MapBuilder.newMapBuilder();
            if (Strings.hasLength((String)clientSettings.getApplicationName())) {
                mapBuilder.put((Object)"user-agent", (Object)clientSettings.getApplicationName());
            }
            return mapBuilder.immutableMap();
        });
        if (Strings.hasLength((String)clientSettings.getHost())) {
            storageOptionsBuilder.setHost(clientSettings.getHost());
        }
        if (Strings.hasLength((String)clientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(clientSettings.getProjectId());
        }
        if (clientSettings.getCredential() == null) {
            logger.warn("\"Application Default Credentials\" are not supported out of the box. Additional file system permissions have to be granted to the plugin.");
        } else {
            ServiceAccountCredentials serviceAccountCredentials = clientSettings.getCredential();
            URI tokenServerUri = clientSettings.getTokenUri();
            if (Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return SocketAccess.doPrivilegedException(() -> storageOptionsBuilder.build());
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }
}

