/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import io.skylite.core.common.Strings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Objects;

public class ProxySettings {
    public static final ProxySettings NO_PROXY_SETTINGS = new ProxySettings(Proxy.Type.DIRECT, null, -1, null, null);
    private final Proxy.Type type;
    private final InetAddress host;
    private final String username;
    private final String password;
    private final int port;

    public ProxySettings(Proxy.Type type, InetAddress host, int port, String username, String password) {
        this.type = type;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public Proxy.Type getType() {
        return this.type;
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticated() {
        return !Strings.isNullOrEmpty((String)this.username) && !Strings.isNullOrEmpty((String)this.password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings that = (ProxySettings)o;
        return this.port == that.port && this.type == that.type && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.host, this.username, this.password, this.port});
    }
}

