/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.repositories.gcs;

import io.skylite.SpecialPermission;
import io.skylite.common.CheckedRunnable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.logging.log4j.core.util.Throwables;

final class SocketAccess {
    private SocketAccess() {
    }

    public static <T> T doPrivilegedIOException(PrivilegedExceptionAction<T> operation) throws IOException {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(operation);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void doPrivilegedVoidIOException(CheckedRunnable<IOException> action) throws IOException {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                action.run();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static <T> T doPrivilegedException(PrivilegedExceptionAction<T> operation) {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(operation);
        }
        catch (PrivilegedActionException e) {
            Throwables.rethrow((Throwable)e.getCause());
            assert (false) : "always throws";
            return null;
        }
    }
}

