/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.http.netty4;

import io.lucenia.transport.netty4.Netty4TcpChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.concurrent.CompletableContext;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.http.HttpChannel;
import io.skylite.core.http.HttpResponse;
import java.net.InetSocketAddress;
import java.util.Optional;

public class Netty4HttpChannel
implements HttpChannel {
    private static final String CHANNEL_PROPERTY = "channel";
    private final Channel channel;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final ChannelPipeline inboundPipeline;

    Netty4HttpChannel(Channel channel) {
        this(channel, null);
    }

    Netty4HttpChannel(Channel channel, ChannelPipeline inboundPipeline) {
        this.channel = channel;
        this.inboundPipeline = inboundPipeline;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
    }

    public void sendResponse(HttpResponse response, ActionListener<Void> listener) {
        this.channel.writeAndFlush((Object)response, Netty4TcpChannel.addPromise(listener, this.channel));
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListenerHelper.toBiConsumer(listener));
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() {
        this.channel.close();
    }

    @Nullable
    public ChannelPipeline inboundPipeline() {
        return this.inboundPipeline;
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public <T> Optional<T> get(String name, Class<T> clazz) {
        if (CHANNEL_PROPERTY.equalsIgnoreCase(name) && clazz.isAssignableFrom(Channel.class)) {
            return Optional.of(this.getNettyChannel());
        }
        ChannelHandler handler = this.getNettyChannel().pipeline().get(name);
        if (handler == null && this.inboundPipeline() != null) {
            handler = this.inboundPipeline().get(name);
        }
        if (handler != null && clazz.isInstance(handler)) {
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public String toString() {
        return "Netty4HttpChannel{localAddress=" + String.valueOf(this.getLocalAddress()) + ", remoteAddress=" + String.valueOf(this.getRemoteAddress()) + "}";
    }
}

