/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.http.netty4;

import io.lucenia.http.netty4.Netty4HttpRequest;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.skylite.common.collect.Tuple;
import io.skylite.core.http.HttpRequest;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.opensearch.http.HttpPipelinedRequest;
import org.opensearch.http.HttpPipelinedResponse;
import org.opensearch.http.HttpPipeliningAggregator;

public class Netty4HttpPipeliningHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private final HttpPipeliningAggregator<ChannelPromise> aggregator;

    public Netty4HttpPipeliningHandler(Logger logger, int maxEventsHeld) {
        this.logger = logger;
        this.aggregator = new HttpPipeliningAggregator(maxEventsHeld);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (msg instanceof Netty4HttpRequest) : "Invalid message type: " + String.valueOf(msg.getClass());
        HttpPipelinedRequest pipelinedRequest = this.aggregator.read((HttpRequest)((Netty4HttpRequest)msg));
        ctx.fireChannelRead((Object)pipelinedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof HttpPipelinedResponse) : "Invalid message type: " + String.valueOf(msg.getClass());
        HttpPipelinedResponse response = (HttpPipelinedResponse)msg;
        boolean success = false;
        try {
            List readyResponses = this.aggregator.write(response, (Object)promise);
            for (Tuple readyResponse : readyResponses) {
                ctx.write((Object)((HttpPipelinedResponse)readyResponse.v1()).getDelegateRequest(), (ChannelPromise)readyResponse.v2());
            }
            success = true;
        }
        catch (IllegalStateException e) {
            ctx.channel().close();
        }
        finally {
            if (!success) {
                promise.setFailure((Throwable)new ClosedChannelException());
            }
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        List inflightResponses = this.aggregator.removeAllInflightResponses();
        if (!inflightResponses.isEmpty()) {
            ClosedChannelException closedChannelException = new ClosedChannelException();
            for (Tuple inflightResponse : inflightResponses) {
                try {
                    ((ChannelPromise)inflightResponse.v2()).setFailure((Throwable)closedChannelException);
                }
                catch (RuntimeException e) {
                    this.logger.error("unexpected error while releasing pipelined http responses", (Throwable)e);
                }
            }
        }
        ctx.close(promise);
    }
}

