/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sgd.linear;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedHashMap;
import org.tribuo.Example;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.ONNXExportable;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.classification.sgd.protos.ClassificationLinearSGDProto;
import org.tribuo.common.sgd.AbstractLinearSGDModel;
import org.tribuo.common.sgd.AbstractSGDModel;
import org.tribuo.impl.ModelDataCarrier;
import org.tribuo.math.LinearParameters;
import org.tribuo.math.Parameters;
import org.tribuo.math.la.DenseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.protos.NormalizerProto;
import org.tribuo.math.protos.ParametersProto;
import org.tribuo.math.util.VectorNormalizer;
import org.tribuo.protos.core.ModelDataProto;
import org.tribuo.protos.core.ModelProto;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.util.onnx.ONNXNode;

public class LinearSGDModel
extends AbstractLinearSGDModel<Label>
implements ONNXExportable {
    private static final long serialVersionUID = 2L;
    public static final int CURRENT_VERSION = 0;
    private final VectorNormalizer normalizer;
    @Deprecated
    private DenseMatrix weights = null;

    LinearSGDModel(String name, ModelProvenance provenance, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Label> outputIDInfo, LinearParameters parameters, VectorNormalizer normalizer, boolean generatesProbabilities) {
        super(name, provenance, featureIDMap, outputIDInfo, parameters, generatesProbabilities);
        this.normalizer = normalizer;
    }

    public static LinearSGDModel deserializeFromProto(int version, String className, Any message) throws InvalidProtocolBufferException {
        if (version < 0 || version > 0) {
            throw new IllegalArgumentException("Unknown version " + version + ", this class supports at most version " + 0);
        }
        ClassificationLinearSGDProto proto = (ClassificationLinearSGDProto)message.unpack(ClassificationLinearSGDProto.class);
        ModelDataCarrier carrier = ModelDataCarrier.deserialize((ModelDataProto)proto.getMetadata());
        if (!carrier.outputDomain().getOutput(0).getClass().equals(Label.class)) {
            throw new IllegalStateException("Invalid protobuf, output domain is not a label domain, found " + carrier.outputDomain().getClass());
        }
        ImmutableOutputInfo outputDomain = carrier.outputDomain();
        Parameters params = Parameters.deserialize((ParametersProto)proto.getParams());
        if (!(params instanceof LinearParameters)) {
            throw new IllegalStateException("Invalid protobuf, parameters must be LinearParameters, found " + params.getClass());
        }
        VectorNormalizer normalizer = VectorNormalizer.deserialize((NormalizerProto)proto.getNormalizer());
        return new LinearSGDModel(carrier.name(), carrier.provenance(), carrier.featureDomain(), (ImmutableOutputInfo<Label>)outputDomain, (LinearParameters)params, normalizer, carrier.generatesProbabilities());
    }

    public Prediction<Label> predict(Example<Label> example) {
        AbstractSGDModel.PredAndActive predTuple = this.predictSingle(example);
        DenseVector prediction = predTuple.prediction;
        prediction.normalize(this.normalizer);
        double maxScore = Double.NEGATIVE_INFINITY;
        Label maxLabel = null;
        LinkedHashMap<String, Label> predMap = new LinkedHashMap<String, Label>();
        for (int i = 0; i < prediction.size(); ++i) {
            String labelName = ((Label)this.outputIDInfo.getOutput(i)).getLabel();
            double score = prediction.get(i);
            Label label = new Label(labelName, score);
            predMap.put(labelName, label);
            if (!(score > maxScore)) continue;
            maxScore = score;
            maxLabel = label;
        }
        return new Prediction(maxLabel, predMap, predTuple.numActiveFeatures - 1, example, this.generatesProbabilities);
    }

    public ModelProto serialize() {
        ModelDataCarrier carrier = this.createDataCarrier();
        ClassificationLinearSGDProto.Builder modelBuilder = ClassificationLinearSGDProto.newBuilder();
        modelBuilder.setMetadata(carrier.serialize());
        modelBuilder.setParams((ParametersProto)this.modelParameters.serialize());
        modelBuilder.setNormalizer((NormalizerProto)this.normalizer.serialize());
        ModelProto.Builder builder = ModelProto.newBuilder();
        builder.setVersion(0);
        builder.setClassName(LinearSGDModel.class.getName());
        builder.setSerializedData(Any.pack((Message)modelBuilder.build()));
        return builder.build();
    }

    protected LinearSGDModel copy(String newName, ModelProvenance newProvenance) {
        return new LinearSGDModel(newName, newProvenance, this.featureIDMap, (ImmutableOutputInfo<Label>)this.outputIDInfo, (LinearParameters)this.modelParameters.copy(), this.normalizer, this.generatesProbabilities);
    }

    protected String getDimensionName(int index) {
        return ((Label)this.outputIDInfo.getOutput(index)).getLabel();
    }

    protected ONNXNode onnxOutput(ONNXNode input) {
        return this.normalizer.exportNormalizer(input);
    }

    protected String onnxModelName() {
        return "Classification-LinearSGDModel";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.weights != null && this.modelParameters == null) {
            this.modelParameters = new LinearParameters(this.weights);
            this.weights = null;
            this.addBias = true;
        }
    }
}

