/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import io.skylite.LuceniaVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public final class LegacyESVersion
extends Version<LegacyESVersion> {
    public static final LegacyESVersion V_EMPTY = new LegacyESVersion(0, org.apache.lucene.util.Version.LATEST);
    public static final LegacyESVersion V_6_0_0 = new LegacyESVersion(6000099, org.apache.lucene.util.Version.fromBits((int)7, (int)0, (int)0));
    public static final LegacyESVersion V_6_5_0 = new LegacyESVersion(6050099, org.apache.lucene.util.Version.fromBits((int)7, (int)0, (int)0));
    public static final LegacyESVersion V_7_2_0 = new LegacyESVersion(7020099, org.apache.lucene.util.Version.fromBits((int)8, (int)0, (int)0));
    protected static final Map<Integer, LegacyESVersion> idToVersion;
    protected static final Map<String, LegacyESVersion> stringToVersion;
    public static final List<LegacyESVersion> declaredVersions;

    protected LegacyESVersion(int id, org.apache.lucene.util.Version luceneVersion) {
        super(id, luceneVersion);
    }

    @Override
    protected Function<Integer, Integer> unmask() {
        return id -> id;
    }

    @Override
    public boolean isBeta() {
        return this.major < 5 ? this.build < 50 : this.build >= 25 && this.build < 50;
    }

    @Override
    public boolean isAlpha() {
        return this.major < 5 ? false : this.build < 25;
    }

    public static LegacyESVersion fromString(String version) {
        if (!Strings.hasLength(version)) {
            return declaredVersions.get(declaredVersions.size() - 1);
        }
        LegacyESVersion cached = stringToVersion.get(version);
        if (cached != null) {
            return cached;
        }
        return (LegacyESVersion)LegacyESVersion.class.cast(LegacyESVersion.fromStringSlow(version, id -> LegacyESVersion.fromId(id)));
    }

    protected int maskId(int id) {
        return id;
    }

    @Override
    protected <V extends Version> boolean isMinCompatibleVersionType(V version) {
        return version instanceof LegacyESVersion;
    }

    @Override
    protected Version computeMinIndexCompatVersion() {
        int bwcMajor;
        int prevLuceneVersionMajor = this.luceneVersion.major - 1;
        if (this.major == 5) {
            bwcMajor = 2;
        } else {
            if (this.major == 7) {
                return LegacyESVersion.fromId(6000026);
            }
            bwcMajor = this.major - 1;
        }
        boolean bwcMinor = false;
        return new LegacyESVersion(bwcMajor * 1000000 + 0 + 99, org.apache.lucene.util.Version.fromBits((int)prevLuceneVersionMajor, (int)0, (int)0));
    }

    @Override
    public int compareMajor(Version<?> other) {
        if (other instanceof OpenSearchVersion) {
            return Integer.compare(this.major, 6 + other.major);
        }
        if (other instanceof LuceniaVersion) {
            return Integer.compare(this.major, 9 + other.major);
        }
        return super.compareMajor(other);
    }

    @Override
    protected <V extends Version> boolean checkMajorVersionCompatibility(V version) {
        if (version instanceof LegacyESVersion) {
            byte a = this.major;
            byte b = ((Version)version).major;
            return Math.max(a, b) - Math.min(a, b) <= 1;
        }
        return ((Version)version).checkMajorVersionCompatibility((LegacyESVersion)this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            if (this.major >= 2) {
                sb.append("-beta");
            } else {
                sb.append(".Beta");
            }
            sb.append(this.major < 5 ? this.build : this.build - 25);
        } else if (this.build < 99) {
            if (this.major >= 2) {
                sb.append("-rc");
            } else {
                sb.append(".RC");
            }
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    static {
        declaredVersions = LegacyESVersion.initializeDeclaredVersions(LegacyESVersion.class);
        Tuple<Map<Integer, LegacyESVersion>, Map<String, LegacyESVersion>> versionMaps = LegacyESVersion.getIdAndStringToVersion(LegacyESVersion.class, Optional.of(Collections.singletonMap(0, V_EMPTY)), Optional.of(Collections.singletonMap(V_EMPTY.toString(), V_EMPTY)));
        idToVersion = (Map)versionMaps.v1();
        stringToVersion = (Map)versionMaps.v2();
    }
}

