/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import com.fasterxml.jackson.core.JsonParseException;
import io.skylite.SkyliteException;
import io.skylite.SkyliteWrapperException;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.CheckedSupplier;
import io.skylite.common.ExceptionsHelper;
import io.skylite.common.util.concurrent.SkyliteRejectedExecutionException;
import io.skylite.core.action.ShardOperationFailedException;
import io.skylite.core.common.concurrent.UncategorizedExecutionException;
import io.skylite.core.compress.NotXContentException;
import io.skylite.core.index.Index;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;

public final class SkyliteExceptionsHelper {
    private static final Logger logger = LogManager.getLogger(SkyliteExceptionsHelper.class);
    private static final List<Class<? extends IOException>> CORRUPTION_EXCEPTIONS = Arrays.asList(CorruptIndexException.class, IndexFormatTooOldException.class, IndexFormatTooNewException.class);

    private SkyliteExceptionsHelper() {
    }

    public static RuntimeException convertToRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new SkyliteException(e);
    }

    public static SkyliteException convertToOpenSearchException(Exception e) {
        if (e instanceof SkyliteException) {
            return (SkyliteException)e;
        }
        return new SkyliteException(e);
    }

    public static RestStatus status(Throwable t) {
        if (t != null) {
            if (t instanceof SkyliteException) {
                return ((SkyliteException)t).status();
            }
            if (t instanceof IllegalArgumentException) {
                return RestStatus.BAD_REQUEST;
            }
            if (t instanceof JsonParseException) {
                return RestStatus.BAD_REQUEST;
            }
            if (t instanceof SkyliteRejectedExecutionException) {
                return RestStatus.TOO_MANY_REQUESTS;
            }
            if (t instanceof NotXContentException) {
                return RestStatus.BAD_REQUEST;
            }
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static String summaryMessage(Throwable t) {
        if (t != null) {
            if (t instanceof SkyliteException) {
                return SkyliteException.getExceptionSimpleClassName(t) + "[" + t.getMessage() + "]";
            }
            if (t instanceof IllegalArgumentException) {
                return "Invalid argument";
            }
            if (t instanceof JsonParseException) {
                return "Failed to parse JSON";
            }
            if (t instanceof SkyliteRejectedExecutionException) {
                return "Too many requests";
            }
        }
        return "Internal failure";
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result = t;
        while (result instanceof SkyliteWrapperException) {
            if (result.getCause() == null) {
                return result;
            }
            if (result.getCause() == result) {
                return result;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t);
                return result;
            }
            result = result.getCause();
        }
        return result;
    }

    @Deprecated
    public static String detailedMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(SkyliteException.getExceptionSimpleClassName(t));
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return SkyliteException.getExceptionSimpleClassName(t) + "[" + t.getMessage() + "]";
    }

    public static <T extends Throwable> void maybeThrowRuntimeAndSuppress(List<T> exceptions) {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = ExceptionsHelper.useOrSuppress(main, (Throwable)ex);
        }
        if (main != null) {
            throw new SkyliteException(main);
        }
    }

    public static IOException unwrapCorruption(Throwable t) {
        return t == null ? null : (IOException)ExceptionsHelper.unwrapCausesAndSuppressed((Throwable)t, cause -> {
            for (Class<? extends IOException> clazz : CORRUPTION_EXCEPTIONS) {
                if (!clazz.isInstance(cause)) continue;
                return true;
            }
            return false;
        }).orElse(null);
    }

    public static Throwable unwrap(Throwable t, Class<?> ... clazzes) {
        if (t != null) {
            Set seen = Collections.newSetFromMap(new IdentityHashMap());
            do {
                if (!seen.add(t)) {
                    return null;
                }
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static void maybeDieOnAnotherThread(Throwable throwable) {
        ExceptionsHelper.maybeError((Throwable)throwable).ifPresent(error -> {
            try {
                String formatted = ExceptionsHelper.formatStackTrace((StackTraceElement[])Thread.currentThread().getStackTrace());
                logger.error("fatal error\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw error;
                }).start();
            }
        });
    }

    public static <R, E extends Exception> R catchAsRuntimeException(CheckedSupplier<R, E> supplier) {
        try {
            return (R)supplier.get();
        }
        catch (Exception e) {
            throw SkyliteExceptionsHelper.convertToRuntime(e);
        }
    }

    public static void catchAsRuntimeException(CheckedRunnable<Exception> runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw SkyliteExceptionsHelper.convertToRuntime(e);
        }
    }

    @SafeVarargs
    public static Exception unwrapAndConvertToException(Throwable throwable, Class<? extends Throwable> ... exceptionTypesToUnwrap) {
        Throwable cause;
        List<Class<? extends Throwable>> unwrapTypes = exceptionTypesToUnwrap.length > 0 ? Arrays.asList(exceptionTypesToUnwrap) : List.of(CompletionException.class);
        for (cause = throwable; cause != null && unwrapTypes.contains(cause.getClass()) && cause.getCause() != null; cause = cause.getCause()) {
        }
        if ((cause = SkyliteExceptionsHelper.getRethrownExecutionExceptionRootCause(cause)) instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new SkyliteException(cause);
    }

    public static Throwable getRethrownExecutionExceptionRootCause(Throwable throwable) {
        if (throwable instanceof UncategorizedExecutionException && throwable.getCause() instanceof ExecutionException) {
            return throwable.getCause().getCause();
        }
        return throwable;
    }

    public static ShardOperationFailedException[] groupBy(ShardOperationFailedException[] failures) {
        ArrayList<ShardOperationFailedException> uniqueFailures = new ArrayList<ShardOperationFailedException>();
        HashSet<GroupBy> reasons = new HashSet<GroupBy>();
        for (ShardOperationFailedException failure : failures) {
            GroupBy reason = new GroupBy(failure);
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
            uniqueFailures.add(failure);
        }
        return uniqueFailures.toArray(new ShardOperationFailedException[0]);
    }

    private static class GroupBy {
        final String reason;
        final String index;
        final Class<? extends Throwable> causeType;

        GroupBy(ShardOperationFailedException failure) {
            Index index;
            Throwable cause = failure.getCause();
            String indexName = failure.index();
            if (indexName == null && cause instanceof SkyliteException && (index = ((SkyliteException)cause).getIndex()) != null) {
                indexName = index.getName();
            }
            this.index = indexName;
            this.reason = cause.getMessage();
            this.causeType = cause.getClass();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupBy groupBy = (GroupBy)o;
            return Objects.equals(this.reason, groupBy.reason) && Objects.equals(this.index, groupBy.index) && Objects.equals(this.causeType, groupBy.causeType);
        }

        public int hashCode() {
            return Objects.hash(this.reason, this.index, this.causeType);
        }
    }
}

