/*
 * Decompiled with CFR 0.152.
 */
package io.skylite;

import io.skylite.LegacyESVersion;
import io.skylite.LuceniaVersion;
import io.skylite.OpenSearchVersion;
import io.skylite.common.Assertions;
import io.skylite.common.collect.Tuple;
import io.skylite.core.common.Strings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract sealed class Version<V extends Version<V>>
implements Comparable<Version<?>>,
ToXContentFragment
permits LuceniaVersion, LegacyESVersion, OpenSearchVersion {
    public static final int V_EMPTY_ID = 0;
    public static final Version V_EMPTY = LegacyESVersion.V_EMPTY;
    public static final Version CURRENT = LuceniaVersion.CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final org.apache.lucene.util.Version luceneVersion;
    protected V minCompatVersion;
    protected V minIndexCompatVersion;

    protected Version(int id, org.apache.lucene.util.Version luceneVersion) {
        this.id = id;
        int unmaskedID = this.unmask().apply(id);
        this.major = (byte)(unmaskedID / 1000000 % 100);
        this.minor = (byte)(unmaskedID / 10000 % 100);
        this.revision = (byte)(unmaskedID / 100 % 100);
        this.build = (byte)(unmaskedID % 100);
        this.luceneVersion = Objects.requireNonNull(luceneVersion);
        this.minCompatVersion = null;
        this.minIndexCompatVersion = null;
    }

    protected abstract Function<Integer, Integer> unmask();

    public static <V extends Version<?>> V min(V version1, V version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static <V extends Version<?>> V max(V version1, V version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public <V extends Version<?>> boolean after(V version) {
        return version.id < this.id;
    }

    public <V extends Version<?>> boolean onOrAfter(V version) {
        return version.id <= this.id;
    }

    public <V extends Version<?>> boolean before(V version) {
        return version.id > this.id;
    }

    public <V extends Version<?>> boolean onOrBefore(V version) {
        return version.id >= this.id;
    }

    public boolean isBeta() {
        return this.build >= 25 && this.build < 50;
    }

    public boolean isAlpha() {
        return this.build < 25;
    }

    public boolean isRC() {
        return this.build > 50 && this.build < 99;
    }

    public boolean isRelease() {
        return this.build == 99;
    }

    public static List<Version<?>> getDeclaredVersions() {
        return DeclaredVersionsHolder.DECLARED_VERSIONS;
    }

    public V minimumWireCompatibilityVersion() {
        V res = this.minCompatVersion;
        if (res == null) {
            this.minCompatVersion = res = this.computeMinCompatVersion();
        }
        return res;
    }

    public V minimumIndexCompatibilityVersion() {
        V res = this.minIndexCompatVersion;
        if (res == null) {
            this.minIndexCompatVersion = res = this.computeMinIndexCompatVersion();
        }
        return res;
    }

    protected abstract <V extends Version> V computeMinIndexCompatVersion();

    protected abstract <V extends Version> boolean isMinCompatibleVersionType(V var1);

    protected <V extends Version> V computeMinCompatVersion() {
        Version<?> bwcVersion = null;
        for (int i = DeclaredVersionsHolder.DECLARED_VERSIONS.size() - 1; i >= 0; --i) {
            Version<?> candidateVersion = DeclaredVersionsHolder.DECLARED_VERSIONS.get(i);
            if (!this.isMinCompatibleVersionType(candidateVersion) || candidateVersion.major != (this.major == 0 ? 2 : this.major - 1) || !candidateVersion.isRelease() || !this.after(candidateVersion)) continue;
            if (bwcVersion != null && candidateVersion.minor < bwcVersion.minor) break;
            bwcVersion = candidateVersion;
        }
        return (V)(bwcVersion == null ? this : bwcVersion);
    }

    public <V extends Version> boolean isCompatible(V version) {
        boolean compatible;
        boolean bl = compatible = this.onOrAfter(((Version)version).minimumWireCompatibilityVersion()) && ((Version)version).onOrAfter(this.minimumWireCompatibilityVersion());
        assert (!compatible || this.checkMajorVersionCompatibility(version));
        return compatible;
    }

    protected abstract <V extends Version> boolean checkMajorVersionCompatibility(V var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.isAlpha()) {
            sb.append("-alpha");
            sb.append(this.build);
        } else if (this.isBeta()) {
            sb.append("-beta");
            sb.append(this.build - 25);
        } else if (this.build < 99) {
            sb.append("-rc");
            sb.append(this.build - 50);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)this.getClass().cast(o);
        return this.id == version.id;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(Version<?> other) {
        return Integer.compare(this.id, other.id);
    }

    public int compareMajor(Version<?> other) {
        return Integer.compare(this.major, other.major);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }

    public static Version<?> fromId(int id) {
        Version known = DeclaredVersionsHolder.ID_TO_VERSION.get(id);
        if (known != null) {
            return known;
        }
        return Version.fromIdSlow(id);
    }

    public static Version<?> create(int id, org.apache.lucene.util.Version luceneVersion) {
        if (id >= 0x10000000) {
            return new LuceniaVersion(LuceniaVersion.unmask(id), luceneVersion);
        }
        if (id >= 0x8000000) {
            return new OpenSearchVersion(OpenSearchVersion.mask(id), luceneVersion);
        }
        return new LegacyESVersion(id, luceneVersion);
    }

    public static <V extends Version> V fromIdSlow(int id) {
        List<Version<?>> versions = DeclaredVersionsHolder.DECLARED_VERSIONS;
        Version<?> tmp = Version.create(id, org.apache.lucene.util.Version.LATEST);
        int index = Collections.binarySearch(versions, tmp);
        if (index < 0) {
            index = -2 - index;
        } else assert (false) : "Version [" + String.valueOf(tmp) + "] is declared but absent from the switch statement in Version#fromId";
        org.apache.lucene.util.Version luceneVersion = index == -1 ? org.apache.lucene.util.Version.fromBits((int)(versions.get((int)0).luceneVersion.major - 1), (int)0, (int)0) : versions.get((int)index).luceneVersion;
        if (id >= 0x10000000) {
            return (V)new LuceniaVersion(id ^ 0x10000000, luceneVersion);
        }
        if (id >= 0x8000000) {
            return (V)new OpenSearchVersion(id ^ 0x8000000, luceneVersion);
        }
        return (V)new LegacyESVersion(id, luceneVersion);
    }

    public static Version fromString(String version) {
        if (!Strings.hasLength(version)) {
            return CURRENT;
        }
        String[] parts = version.split("[.-]");
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        int major = Integer.parseInt(parts[0]);
        if (major >= 1 && major < 6) {
            return OpenSearchVersion.fromString(version);
        }
        if (major > 3) {
            return LegacyESVersion.fromString(version);
        }
        return LuceniaVersion.fromString(version);
    }

    static <V extends Version> V fromStringSlow(String version, Function<Integer, V> fromId) {
        if (version.endsWith("-SNAPSHOT")) {
            throw new IllegalArgumentException("illegal version format - snapshot labels are not supported");
        }
        String[] parts = version.split("[.-]");
        if (parts.length < 3 || parts.length > 4) {
            throw new IllegalArgumentException("the version needs to contain major, minor, and revision, and optionally the build: " + version);
        }
        try {
            int rawMajor = Integer.parseInt(parts[0]);
            int betaOffset = 25;
            int major = rawMajor * 1000000;
            int minor = Integer.parseInt(parts[1]) * 10000;
            int revision = Integer.parseInt(parts[2]) * 100;
            int build = 99;
            if (parts.length == 4) {
                String buildStr = parts[3];
                if (buildStr.startsWith("alpha")) {
                    build = Integer.parseInt(buildStr.substring(5));
                    assert (build < 25) : "expected a alpha build but " + build + " >= 25";
                } else if (buildStr.startsWith("Beta") || buildStr.startsWith("beta")) {
                    build = 25 + Integer.parseInt(buildStr.substring(4));
                    assert (build < 50) : "expected a beta build but " + build + " >= 50";
                } else if (buildStr.startsWith("RC") || buildStr.startsWith("rc")) {
                    build = Integer.parseInt(buildStr.substring(2)) + 50;
                } else {
                    throw new IllegalArgumentException("unable to parse version " + version);
                }
            }
            return (V)((Version)fromId.apply(major + minor + revision + build));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version " + version, e);
        }
    }

    static <V extends Version> Tuple<Map<Integer, V>, Map<String, V>> getIdAndStringToVersion(Class<V> clazz, Optional<Map<Integer, V>> optionalIntToVersions, Optional<Map<String, V>> optionalStringToVersions) {
        HashMap<Integer, Version<V>> builder = new HashMap<Integer, Version<V>>();
        HashMap<String, Version<V>> builderByString = new HashMap<String, Version<V>>();
        for (Field declaredField : clazz.getFields()) {
            String fieldName;
            if (!declaredField.getType().equals(clazz) || (fieldName = declaredField.getName()).equals("CURRENT") || fieldName.equals("V_EMPTY")) continue;
            assert (fieldName.matches("V_\\d+_\\d+_\\d+(_alpha[1,2]|_beta[1,2]|_rc[1,2])?")) : "expected Version field [" + fieldName + "] to match V_\\d+_\\d+_\\d+";
            try {
                Version version = (Version)declaredField.get(null);
                if (Assertions.ENABLED) {
                    String[] fields = fieldName.split("_");
                    if (fields.length == 5) {
                        assert ((fields[1].equals("1") || fields[1].equals("6")) && fields[2].equals("0")) : "field " + fieldName + " should not have a build qualifier";
                    } else {
                        int major = Integer.valueOf(fields[1]) * 1000000;
                        int minor = Integer.valueOf(fields[2]) * 10000;
                        int revision = Integer.valueOf(fields[3]) * 100;
                        int unmaskedMajor = major + minor + revision + 99;
                        int expectedId = major == 0 ? 0x10000000 ^ unmaskedMajor : (major > 0 && major < 6000000 ? 0x8000000 ^ unmaskedMajor : unmaskedMajor);
                        assert (version.id == expectedId) : "expected version [" + fieldName + "] to have id [" + expectedId + "] but was [" + version.id + "]";
                    }
                }
                Version maybePrevious = builder.put(version.id, version);
                builderByString.put(version.toString(), version);
                if ($assertionsDisabled || maybePrevious == null) continue;
                throw new AssertionError((Object)("expected [" + version.id + "] to be uniquely mapped but saw [" + String.valueOf(maybePrevious) + "] and [" + String.valueOf(version) + "]"));
            }
            catch (IllegalAccessException e) {
                assert (false) : "Version field [" + fieldName + "] should be public";
            }
            catch (RuntimeException e) {
                assert (false) : "Version field [" + fieldName + "] threw [" + String.valueOf(e) + "] during initialization";
            }
        }
        if (optionalIntToVersions.isPresent()) {
            builder.putAll(optionalIntToVersions.get());
        }
        if (optionalStringToVersions.isPresent()) {
            builderByString.putAll(optionalStringToVersions.get());
        }
        return new Tuple(Map.copyOf(builder), Map.copyOf(builderByString));
    }

    public static <V extends Version> List<V> initializeDeclaredVersions(Class<?> clazz) {
        Field[] fields = clazz.getFields();
        ArrayList<Version> versions = new ArrayList<Version>(fields.length);
        block9: for (Field field : fields) {
            int mod = field.getModifiers();
            if (!Modifier.isStatic(mod) && Modifier.isFinal(mod) && Modifier.isPublic(mod) || field.getType() != clazz) continue;
            switch (field.getName()) {
                case "CURRENT": 
                case "V_EMPTY": {
                    continue block9;
                }
                default: {
                    assert (field.getName().matches("V(_\\d+)+(_(alpha|beta|rc)\\d+)?")) : field.getName();
                    try {
                        versions.add((Version)field.get(null));
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        Collections.sort(versions);
        return Collections.unmodifiableList(versions);
    }

    static class DeclaredVersionsHolder {
        protected static final List<Version<?>> DECLARED_VERSIONS = Stream.concat(Stream.concat(LegacyESVersion.declaredVersions.stream(), OpenSearchVersion.declaredVersions.stream()), LuceniaVersion.declaredVersions.stream()).sorted().collect(Collectors.toList());
        protected static final Map<Integer, Version> ID_TO_VERSION = new HashMap<Integer, Version>(LegacyESVersion.idToVersion.size() + OpenSearchVersion.idToVersion.size() + LuceniaVersion.idToVersion.size());
        protected static final Map<String, Version> STRING_TO_VERSION = new HashMap<String, Version>(ID_TO_VERSION.size());

        DeclaredVersionsHolder() {
        }

        static {
            Tuple merger = new Tuple((key, value) -> {
                if (ID_TO_VERSION.containsKey(key)) {
                    throw new IllegalArgumentException("id to version should not have duplicate versions");
                }
                ID_TO_VERSION.put((Integer)key, (Version)value);
            }, (key, value) -> {
                if (STRING_TO_VERSION.containsKey(key)) {
                    throw new IllegalArgumentException("string to version should not have duplicate versions");
                }
                STRING_TO_VERSION.put((String)key, (Version)value);
            });
            LegacyESVersion.idToVersion.forEach((BiConsumer)merger.v1());
            LegacyESVersion.stringToVersion.forEach((BiConsumer)merger.v2());
            OpenSearchVersion.idToVersion.forEach((BiConsumer)merger.v1());
            OpenSearchVersion.stringToVersion.forEach((BiConsumer)merger.v2());
            LuceniaVersion.idToVersion.forEach((BiConsumer)merger.v1());
            LuceniaVersion.stringToVersion.forEach((BiConsumer)merger.v2());
        }
    }
}

