/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core;

import io.skylite.common.annotation.PublicApi;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.XContentLocation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;

@PublicApi(since="1.0.0")
public class ParseField {
    public static final String SINGLE_MAPPING_NAME = "_doc";
    private final String name;
    private final String[] deprecatedNames;
    private String allReplacedWith = null;
    private final String[] allNames;
    private boolean fullyDeprecated = false;
    private static final String[] EMPTY = new String[0];

    public ParseField(String name, String ... deprecatedNames) {
        this.name = Objects.requireNonNull(name);
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = EMPTY;
        } else {
            HashSet set = new HashSet();
            Collections.addAll(set, deprecatedNames);
            this.deprecatedNames = set.toArray(new String[0]);
        }
        HashSet<String> allNames = new HashSet<String>();
        allNames.add(name);
        Collections.addAll(allNames, this.deprecatedNames);
        this.allNames = allNames.toArray(new String[0]);
    }

    public String getPreferredName() {
        return this.name;
    }

    public String[] getAllNamesIncludedDeprecated() {
        return this.allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNames) {
        return new ParseField(this.name, deprecatedNames);
    }

    public ParseField withAllDeprecated(String allReplacedWith) {
        ParseField parseField = this.withDeprecation(this.getAllNamesIncludedDeprecated());
        parseField.allReplacedWith = allReplacedWith;
        return parseField;
    }

    public ParseField withAllDeprecated() {
        ParseField parseField = this.withDeprecation(this.getAllNamesIncludedDeprecated());
        parseField.fullyDeprecated = true;
        return parseField;
    }

    public boolean match(String fieldName, DeprecationHandler deprecationHandler) {
        return this.match(null, () -> XContentLocation.UNKNOWN, fieldName, deprecationHandler);
    }

    public boolean match(String parserName, Supplier<XContentLocation> location, String fieldName, DeprecationHandler deprecationHandler) {
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        if (!this.fullyDeprecated && this.allReplacedWith == null && fieldName.equals(this.name)) {
            return true;
        }
        for (String depName : this.deprecatedNames) {
            if (!fieldName.equals(depName)) continue;
            if (this.fullyDeprecated) {
                deprecationHandler.usedDeprecatedField(parserName, location, fieldName);
            } else if (this.allReplacedWith == null) {
                deprecationHandler.usedDeprecatedName(parserName, location, fieldName, this.name);
            } else {
                deprecationHandler.usedDeprecatedField(parserName, location, fieldName, this.allReplacedWith);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPreferredName();
    }

    public String getAllReplacedWith() {
        return this.allReplacedWith;
    }

    public String[] getDeprecatedNames() {
        return this.deprecatedNames;
    }

    public static class CoreTypes {
        public static final ParseField OBJECT_FIELD = new ParseField("object", new String[0]);
        public static final ParseField TEXT_FIELD = new ParseField("text", new String[0]);
        public static final ParseField LONG_FIELD = new ParseField("long", new String[0]);
        public static final ParseField FLOAT_FIELD = new ParseField("float", new String[0]);
        public static final ParseField BOOLEAN_FIELD = new ParseField("boolean", new String[0]);
        public static final ParseField DATE_FIELD = new ParseField("date", new String[0]);
        public static final ParseField BINARY_FIELD = new ParseField("binary", new String[0]);
    }

    public static class CommonMetaFields {
        public static final ParseField ID_FIELD = new ParseField("_id", new String[0]);
        public static final ParseField IGNORED_FIELD = new ParseField("_ignored", new String[0]);
        public static final ParseField NAME_FIELD = new ParseField("_name", new String[0]);
        public static final ParseField SOURCE_FIELD = new ParseField("_source", new String[0]);
        public static final ParseField VERSION_FIELD = new ParseField("_version", new String[0]);
        public static final ParseField ROUTING_FIELD = new ParseField("_routing", new String[0]);
        public static final ParseField SEQ_NO_FIELD = new ParseField("_seq_no", new String[0]);
        public static final ParseField PRIMARY_TERM_FIELD = new ParseField("_primary_term", new String[0]);
        public static final ParseField TOMBSTONE_FIELD = new ParseField("_tombstone", new String[0]);
        public static final ParseField FIELD_NAMES_FIELD = new ParseField("_field_names", new String[0]);
    }

    public static class CommonFields {
        public static final ParseField DOC_VALUES = new ParseField("doc_values", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("@timestamp", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
        public static final ParseField MISSING = new ParseField("missing", new String[0]);
        public static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
        public static final ParseField _META = new ParseField("_meta", new String[0]);
        public static final ParseField IGNORE_MALFORMED = new ParseField("ignore_malformed", new String[0]);
        public static final ParseField IGNORE_Z_VALUE = new ParseField("ignore_z_value", new String[0]);
        public static final ParseField NULL_VALUE = new ParseField("null_value", new String[0]);
        public static final ParseField DATE_NANOS = new ParseField("date_nanos", new String[0]);
        public static final ParseField POINT_IN_TIME = new ParseField("pit", new String[0]);
        public static final ParseField LTE_FIELD = new ParseField("lte", new String[0]);
        public static final ParseField GTE_FIELD = new ParseField("gte", new String[0]);
        public static final ParseField GT_FIELD = new ParseField("gt", new String[0]);
        public static final ParseField LT_FIELD = new ParseField("lt", new String[0]);
    }
}

