/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.common.action.ActionListener;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportResponse;
import io.skylite.core.transport.TransportResponseHandler;
import java.io.IOException;
import java.util.Objects;

public class ActionListenerResponseHandler<Response extends TransportResponse>
implements TransportResponseHandler<Response> {
    private final ActionListener<? super Response> listener;
    private final Writeable.Reader<Response> reader;
    private final String executor;

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader, String executor) {
        this.listener = Objects.requireNonNull(listener);
        this.reader = Objects.requireNonNull(reader);
        this.executor = Objects.requireNonNull(executor);
    }

    public ActionListenerResponseHandler(ActionListener<? super Response> listener, Writeable.Reader<Response> reader) {
        this(listener, reader, "same");
    }

    @Override
    public void handleResponse(Response response) {
        this.listener.onResponse(response);
    }

    @Override
    public void handleException(TransportException e) {
        this.listener.onFailure((Exception)e);
    }

    @Override
    public String executor() {
        return this.executor;
    }

    @Override
    public Response read(StreamInput in) throws IOException {
        return (Response)((TransportResponse)this.reader.read(in));
    }

    public String toString() {
        return super.toString() + "/" + String.valueOf(this.listener);
    }
}

