/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.common.action.ActionFuture;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.client.SkyliteClient;
import java.util.Objects;

public abstract class ActionRequestBuilder<Request extends ActionRequest, Response extends ActionResponse> {
    protected final ActionType<Response> action;
    protected final Request request;
    protected final SkyliteClient client;

    protected ActionRequestBuilder(SkyliteClient client, ActionType<Response> action, Request request) {
        Objects.requireNonNull(action, "action must not be null");
        this.action = action;
        this.request = request;
        this.client = client;
    }

    public Request request() {
        return this.request;
    }

    public ActionFuture<Response> execute() {
        return this.client.execute(this.action, this.request);
    }

    public Response get() {
        return (Response)((ActionResponse)this.execute().actionGet());
    }

    public Response get(TimeValue timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public Response get(String timeout) {
        return (Response)((ActionResponse)this.execute().actionGet(timeout));
    }

    public void execute(ActionListener<Response> listener) {
        this.client.execute(this.action, this.request, listener);
    }
}

