/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.common.concurrent.AtomicArray;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class GroupedActionListener<T>
implements ActionListener<T> {
    private final CountDown countDown;
    private final AtomicInteger pos = new AtomicInteger();
    private final AtomicArray<T> results;
    private final ActionListener<Collection<T>> delegate;
    private final AtomicReference<Exception> failure = new AtomicReference();

    public GroupedActionListener(ActionListener<Collection<T>> delegate, int groupSize) {
        if (groupSize <= 0) {
            throw new IllegalArgumentException("groupSize must be greater than 0 but was " + groupSize);
        }
        this.results = new AtomicArray(groupSize);
        this.countDown = new CountDown(groupSize);
        this.delegate = delegate;
    }

    public void onResponse(T element) {
        this.results.setOnce(this.pos.incrementAndGet() - 1, element);
        if (this.countDown.countDown()) {
            if (this.failure.get() != null) {
                this.delegate.onFailure(this.failure.get());
            } else {
                List<T> collect = this.results.asList();
                this.delegate.onResponse(Collections.unmodifiableList(collect));
            }
        }
    }

    public void onFailure(Exception e) {
        if (!this.failure.compareAndSet(null, e)) {
            this.failure.accumulateAndGet(e, (current, update) -> {
                if (update != current) {
                    current.addSuppressed((Throwable)update);
                }
                return current;
            });
        }
        if (this.countDown.countDown()) {
            this.delegate.onFailure(this.failure.get());
        }
    }
}

