/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public interface WriteRequest<R extends WriteRequest<R>>
extends Writeable {
    public R setRefreshPolicy(RefreshPolicy var1);

    default public R setRefreshPolicy(String refreshPolicy) {
        if (refreshPolicy != null) {
            this.setRefreshPolicy(RefreshPolicy.parse(refreshPolicy));
        }
        return (R)this;
    }

    public RefreshPolicy getRefreshPolicy();

    public ActionRequestValidationException validate();

    public static enum RefreshPolicy implements Writeable
    {
        NONE("false"),
        IMMEDIATE("true"),
        WAIT_UNTIL("wait_for");

        private final String value;

        private RefreshPolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static RefreshPolicy parse(String value) {
            for (RefreshPolicy policy : RefreshPolicy.values()) {
                if (!policy.getValue().equals(value)) continue;
                return policy;
            }
            if ("".equals(value)) {
                return IMMEDIATE;
            }
            throw new IllegalArgumentException("Unknown value for refresh: [" + value + "].");
        }

        public static RefreshPolicy readFrom(StreamInput in) throws IOException {
            return RefreshPolicy.values()[in.readByte()];
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte((byte)this.ordinal());
        }
    }
}

