/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.configuration;

import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import io.skylite.core.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import io.skylite.core.cluster.coordination.CoordinationMetadata;
import io.skylite.core.cluster.metadata.Metadata;
import io.skylite.core.cluster.state.ClusterState;
import java.util.Set;

public class VotingConfigExclusionsHelper {
    public static ClusterState addExclusionAndGetState(ClusterState currentState, Set<CoordinationMetadata.VotingConfigExclusion> resolvedExclusions, int finalMaxVotingConfigExclusions) {
        CoordinationMetadata.Builder builder = CoordinationMetadata.builder(currentState.coordinationMetadata());
        resolvedExclusions.forEach(builder::addVotingConfigExclusion);
        Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(builder.build()).build();
        ClusterState newState = ClusterState.builder(currentState).metadata(newMetadata).build();
        assert (newState.getVotingConfigExclusions().size() <= finalMaxVotingConfigExclusions);
        return newState;
    }

    public static Set<CoordinationMetadata.VotingConfigExclusion> resolveVotingConfigExclusionsAndCheckMaximum(AddVotingConfigExclusionsRequest request, ClusterState state, int maxVotingConfigExclusions) {
        return request.resolveVotingConfigExclusionsAndCheckMaximum(state, maxVotingConfigExclusions, AddVotingConfigExclusionsAction.MAXIMUM_VOTING_CONFIG_EXCLUSIONS_SETTING.getKey());
    }

    public static ClusterState clearExclusionsAndGetState(ClusterState currentState) {
        CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).clearVotingConfigExclusions().build();
        Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(newCoordinationMetadata).build();
        return ClusterState.builder(currentState).metadata(newMetadata).build();
    }
}

