/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.node.reload;

import io.skylite.common.CharArrays;
import io.skylite.common.Nullable;
import io.skylite.common.SecureString;
import io.skylite.core.action.support.nodes.BaseNodesRequest;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.Arrays;

public class NodesReloadSecureSettingsRequest
extends BaseNodesRequest<NodesReloadSecureSettingsRequest> {
    @Nullable
    private SecureString secureSettingsPassword;

    public NodesReloadSecureSettingsRequest() {
        super((String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesReloadSecureSettingsRequest(StreamInput in) throws IOException {
        super(in);
        BytesReference bytesRef = in.readOptionalBytesReference();
        if (bytesRef != null) {
            byte[] bytes = BytesReference.toBytes(bytesRef);
            try {
                this.secureSettingsPassword = new SecureString(CharArrays.utf8BytesToChars((byte[])bytes));
            }
            finally {
                Arrays.fill(bytes, (byte)0);
            }
        } else {
            this.secureSettingsPassword = null;
        }
    }

    public NodesReloadSecureSettingsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    @Nullable
    public SecureString getSecureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    public void setSecureStorePassword(SecureString secureStorePassword) {
        this.secureSettingsPassword = secureStorePassword;
    }

    public void closePassword() {
        if (this.secureSettingsPassword != null) {
            this.secureSettingsPassword.close();
        }
    }

    public boolean hasPassword() {
        return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.secureSettingsPassword == null) {
            out.writeOptionalBytesReference(null);
        } else {
            byte[] passwordBytes = CharArrays.toUtf8Bytes((char[])this.secureSettingsPassword.getChars());
            try {
                out.writeOptionalBytesReference(new BytesArray(passwordBytes));
            }
            finally {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }
}

