/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.node.tasks.cancel;

import io.skylite.core.action.support.tasks.BaseTasksRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.CancellableTask;
import io.skylite.core.tasks.Task;
import java.io.IOException;
import java.util.Arrays;

public class CancelTasksRequest
extends BaseTasksRequest<CancelTasksRequest> {
    public static final String DEFAULT_REASON = "by user request";
    public static final boolean DEFAULT_WAIT_FOR_COMPLETION = false;
    private String reason = "by user request";
    private boolean waitForCompletion = false;

    public CancelTasksRequest() {
    }

    public CancelTasksRequest(StreamInput in) throws IOException {
        super(in);
        this.reason = in.readString();
        this.waitForCompletion = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.reason);
        out.writeBoolean(this.waitForCompletion);
    }

    @Override
    public boolean match(Task task) {
        return super.match(task) && task instanceof CancellableTask;
    }

    public CancelTasksRequest setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public String getDescription() {
        return "reason[" + this.reason + "], waitForCompletion[" + this.waitForCompletion + "], taskId[" + String.valueOf(this.getTaskId()) + "], parentTaskId[" + String.valueOf(this.getParentTaskId()) + "], nodes" + Arrays.toString(this.getNodes()) + ", actions" + Arrays.toString(this.getActions());
    }
}

