/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.node.usage;

import io.skylite.core.action.support.nodes.BaseNodeResponse;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Map;

public class NodeUsage
extends BaseNodeResponse
implements ToXContentFragment {
    private final long timestamp;
    private final long sinceTime;
    private final Map<String, Long> restUsage;
    private final Map<String, Object> aggregationUsage;

    public NodeUsage(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readLong();
        this.sinceTime = in.readLong();
        this.restUsage = (Map)in.readGenericValue();
        this.aggregationUsage = (Map)in.readGenericValue();
    }

    public NodeUsage(DiscoveryNode node, long timestamp, long sinceTime, Map<String, Long> restUsage, Map<String, Object> aggregationUsage) {
        super(node);
        this.timestamp = timestamp;
        this.sinceTime = sinceTime;
        this.restUsage = restUsage;
        this.aggregationUsage = aggregationUsage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSinceTime() {
        return this.sinceTime;
    }

    public Map<String, Long> getRestUsage() {
        return this.restUsage;
    }

    public Map<String, Object> getAggregationUsage() {
        return this.aggregationUsage;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("since", this.sinceTime);
        if (this.restUsage != null) {
            builder.field("rest_actions");
            builder.map(this.restUsage);
        }
        if (this.aggregationUsage != null) {
            builder.field("aggregations");
            builder.map(this.aggregationUsage);
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.timestamp);
        out.writeLong(this.sinceTime);
        out.writeGenericValue(this.restUsage);
        out.writeGenericValue(this.aggregationUsage);
    }
}

