/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.settings;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.ParseField;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Map;

public class ClusterUpdateSettingsRequest
extends AcknowledgedRequest<ClusterUpdateSettingsRequest>
implements ToXContentObject {
    private static final ParseField PERSISTENT = new ParseField("persistent", new String[0]);
    private static final ParseField TRANSIENT = new ParseField("transient", new String[0]);
    private static final ObjectParser<ClusterUpdateSettingsRequest, Void> PARSER = new ObjectParser("cluster_update_settings_request", false, ClusterUpdateSettingsRequest::new);
    private Settings transientSettings = Settings.Builder.EMPTY_SETTINGS;
    private Settings persistentSettings = Settings.Builder.EMPTY_SETTINGS;

    public ClusterUpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.transientSettings = Settings.readSettingsFromStream(in);
        this.persistentSettings = Settings.readSettingsFromStream(in);
    }

    public ClusterUpdateSettingsRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.transientSettings.isEmpty() && this.persistentSettings.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"no settings to update", validationException);
        }
        return validationException;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public ClusterUpdateSettingsRequest transientSettings(Settings settings) {
        this.transientSettings = settings;
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(Settings.Builder settings) {
        this.transientSettings = settings.build();
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(String source, MediaType mediaType) {
        this.transientSettings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(Map<String, ?> source) {
        this.transientSettings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Settings settings) {
        this.persistentSettings = settings;
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Settings.Builder settings) {
        this.persistentSettings = settings.build();
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(String source, MediaType mediaType) {
        this.persistentSettings = Settings.builder().loadFromSource(source, mediaType).build();
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Map<String, ?> source) {
        this.persistentSettings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Settings.writeSettingsToStream(this.transientSettings, out);
        Settings.writeSettingsToStream(this.persistentSettings, out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(PERSISTENT.getPreferredName());
        this.persistentSettings.toXContent(builder, params);
        builder.endObject();
        builder.startObject(TRANSIENT.getPreferredName());
        this.transientSettings.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ClusterUpdateSettingsRequest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject((r, p) -> {
            r.persistentSettings = p;
        }, (p, c) -> Settings.fromXContent(p), PERSISTENT);
        PARSER.declareObject((r, t) -> {
            r.transientSettings = t;
        }, (p, c) -> Settings.fromXContent(p), TRANSIENT);
    }
}

