/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.snapshots.restore;

import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.cluster.RestoreInProgress;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterStateChangedEvent;
import io.skylite.core.cluster.state.ClusterStateListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.snapshots.RestoreCompletionResponse;
import io.skylite.core.snapshots.RestoreInfo;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestoreClusterStateListener<T extends ActionResponse>
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(RestoreClusterStateListener.class);
    private final ClusterService clusterService;
    private final String uuid;
    private final String restoreIdentifier;
    private final ActionListener<T> listener;
    private final Function<RestoreInfo, T> actionResponseFactory;

    private RestoreClusterStateListener(ClusterService clusterService, RestoreCompletionResponse response, ActionListener<T> listener, Function<RestoreInfo, T> actionResponseFactory) {
        this.clusterService = clusterService;
        this.uuid = response.getUuid();
        this.restoreIdentifier = response.getSnapshot() != null ? response.getSnapshot().getSnapshotId().getName() : "remote_store";
        this.listener = listener;
        this.actionResponseFactory = actionResponseFactory;
    }

    @Override
    public void clusterChanged(ClusterStateChangedEvent changedEvent) {
        RestoreInProgress.Entry prevEntry = RestoreInProgress.restoreInProgress(changedEvent.previousState(), this.uuid);
        RestoreInProgress.Entry newEntry = RestoreInProgress.restoreInProgress(changedEvent.state(), this.uuid);
        if (prevEntry == null) {
            this.clusterService.removeListener(this);
            this.listener.onResponse((Object)((ActionResponse)this.actionResponseFactory.apply(null)));
        } else if (newEntry == null) {
            this.clusterService.removeListener(this);
            Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = prevEntry.shards();
            assert (prevEntry.state().completed()) : "expected completed snapshot/remote store restore state but was " + String.valueOf((Object)prevEntry.state());
            assert (RestoreInProgress.completed(shards)) : "expected all restore entries to be completed";
            RestoreInfo ri = new RestoreInfo(this.restoreIdentifier, prevEntry.indices(), shards.size(), shards.size() - RestoreInProgress.failedShards(shards));
            ActionResponse response = (ActionResponse)this.actionResponseFactory.apply(ri);
            logger.debug("restore of [{}] completed", (Object)this.restoreIdentifier);
            this.listener.onResponse((Object)response);
        } else {
            logger.debug("restore not completed yet, wait for next cluster state update");
        }
    }

    public static <T extends ActionResponse> void createAndRegisterListener(ClusterService clusterService, RestoreCompletionResponse response, ActionListener<T> listener, Function<RestoreInfo, T> actionResponseFactory) {
        clusterService.addListener(new RestoreClusterStateListener<T>(clusterService, response, listener, actionResponseFactory));
    }
}

