/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.snapshots.status;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.ClusterManagerNodeRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class SnapshotsStatusRequest
extends ClusterManagerNodeRequest<SnapshotsStatusRequest> {
    private String repository = "_all";
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;

    public SnapshotsStatusRequest() {
    }

    public SnapshotsStatusRequest(String repository, String[] snapshots) {
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public SnapshotsStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
        this.ignoreUnavailable = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.ignoreUnavailable);
    }

    public SnapshotsStatusRequest(String repository) {
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError((String)"repository is missing", validationException);
        }
        if (this.snapshots == null) {
            validationException = ValidateActions.addValidationError((String)"snapshots is null", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public SnapshotsStatusRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public SnapshotsStatusRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public SnapshotsStatusRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }
}

