/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.stats;

import io.skylite.core.action.FailedNodeException;
import io.skylite.core.action.admin.cluster.stats.AnalysisStats;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsIndices;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsNodeResponse;
import io.skylite.core.action.admin.cluster.stats.ClusterStatsNodes;
import io.skylite.core.action.admin.cluster.stats.MappingStats;
import io.skylite.core.action.support.nodes.BaseNodesResponse;
import io.skylite.core.cluster.ClusterName;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContentFragment {
    final ClusterStatsNodes nodesStats;
    final ClusterStatsIndices indicesStats;
    final ClusterHealthStatus status;
    final long timestamp;
    final String clusterUUID;

    public ClusterStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.timestamp = in.readVLong();
        this.status = in.readOptionalWriteable(ClusterHealthStatus::readFrom);
        String clusterUUID = null;
        MappingStats mappingStats = null;
        AnalysisStats analysisStats = null;
        clusterUUID = in.readOptionalString();
        mappingStats = in.readOptionalWriteable(MappingStats::new);
        analysisStats = in.readOptionalWriteable(AnalysisStats::new);
        this.clusterUUID = clusterUUID;
        this.nodesStats = new ClusterStatsNodes(this.getNodes());
        this.indicesStats = new ClusterStatsIndices(this.getNodes(), mappingStats, analysisStats);
    }

    public ClusterStatsResponse(long timestamp, String clusterUUID, ClusterName clusterName, List<ClusterStatsNodeResponse> nodes, List<FailedNodeException> failures, ClusterState state) {
        super(clusterName, nodes, failures);
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes, MappingStats.of(state), AnalysisStats.of(state));
        ClusterHealthStatus status = null;
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            status = response.clusterStatus();
            break;
        }
        this.status = status;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        out.writeOptionalWriteable(this.status);
        out.writeOptionalString(this.clusterUUID);
        out.writeOptionalWriteable(this.indicesStats.getMappings());
        out.writeOptionalWriteable(this.indicesStats.getAnalysis());
    }

    @Override
    protected List<ClusterStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(ClusterStatsNodeResponse::readNodeResponse);
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<ClusterStatsNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_uuid", this.getClusterUUID());
        builder.field("timestamp", this.getTimestamp());
        if (this.status != null) {
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("indices");
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("nodes");
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = MediaTypeRegistry.JSON.contentBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.toString();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

