/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.stats;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public final class IndexFeatureStats
implements ToXContent,
Writeable {
    final String name;
    int count;
    int indexCount;

    IndexFeatureStats(String name) {
        this.name = Objects.requireNonNull(name);
    }

    IndexFeatureStats(StreamInput in) throws IOException {
        this.name = in.readString();
        this.count = in.readVInt();
        this.indexCount = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVInt(this.count);
        out.writeVInt(this.indexCount);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndexFeatureStats)) {
            return false;
        }
        IndexFeatureStats that = (IndexFeatureStats)other;
        return this.name.equals(that.name) && this.count == that.count && this.indexCount == that.indexCount;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.count, this.indexCount);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("count", this.count);
        builder.field("index_count", this.indexCount);
        builder.endObject();
        return builder;
    }
}

