/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.storedscripts;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.AcknowledgedRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class DeleteStoredScriptRequest
extends AcknowledgedRequest<DeleteStoredScriptRequest> {
    private String id;

    public DeleteStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
    }

    DeleteStoredScriptRequest() {
    }

    public DeleteStoredScriptRequest(String id) {
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError((String)"id cannot contain '#' for stored script", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public DeleteStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    public String toString() {
        return "delete stored script {id [" + this.id + "]}";
    }
}

