/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.storedscripts;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class GetStoredScriptRequest
extends ClusterManagerNodeReadRequest<GetStoredScriptRequest> {
    protected String id;

    GetStoredScriptRequest() {
    }

    public GetStoredScriptRequest(String id) {
        this.id = id;
    }

    public GetStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError((String)"id cannot contain '#' for stored script", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public GetStoredScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String toString() {
        return "get script [" + this.id + "]";
    }
}

