/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.cluster.tasks.get;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.tasks.TaskId;
import java.io.IOException;

public class GetTaskRequest
extends ActionRequest {
    private TaskId taskId = TaskId.EMPTY_TASK_ID;
    private boolean waitForCompletion = false;
    private TimeValue timeout = null;

    public GetTaskRequest() {
    }

    public GetTaskRequest(StreamInput in) throws IOException {
        super(in);
        this.taskId = TaskId.readFromStream(in);
        this.timeout = in.readOptionalTimeValue();
        this.waitForCompletion = in.readBoolean();
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public GetTaskRequest setTaskId(TaskId taskId) {
        this.taskId = taskId;
        return this;
    }

    public boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public GetTaskRequest setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public GetTaskRequest setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public GetTaskRequest nodeRequest(String thisNodeId, long thisTaskId) {
        GetTaskRequest copy = new GetTaskRequest();
        copy.setParentTask(thisNodeId, thisTaskId);
        copy.setTaskId(this.taskId);
        copy.setTimeout(this.timeout);
        copy.setWaitForCompletion(this.waitForCompletion);
        return copy;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!this.getTaskId().isSet()) {
            validationException = ValidateActions.addValidationError((String)"task id is required", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.taskId.writeTo(out);
        out.writeOptionalTimeValue(this.timeout);
        out.writeBoolean(this.waitForCompletion);
    }
}

