/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.cache.clear;

import io.skylite.OpenSearchVersion;
import io.skylite.core.action.support.broadcast.BroadcastRequest;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;

public class ClearIndicesCacheRequest
extends BroadcastRequest<ClearIndicesCacheRequest> {
    private boolean queryCache = false;
    private boolean fieldDataCache = false;
    private boolean requestCache = false;
    private boolean fileCache = false;
    private String[] fields = Strings.EMPTY_ARRAY;

    public ClearIndicesCacheRequest(StreamInput in) throws IOException {
        super(in);
        this.queryCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.fields = in.readStringArray();
        this.requestCache = in.readBoolean();
        if (in.getVersion().onOrAfter(OpenSearchVersion.V_2_8_0)) {
            this.fileCache = in.readBoolean();
        }
    }

    public ClearIndicesCacheRequest(String ... indices) {
        super(indices);
    }

    public boolean queryCache() {
        return this.queryCache;
    }

    public ClearIndicesCacheRequest queryCache(boolean queryCache) {
        this.queryCache = queryCache;
        return this;
    }

    public boolean requestCache() {
        return this.requestCache;
    }

    public ClearIndicesCacheRequest requestCache(boolean requestCache) {
        this.requestCache = requestCache;
        return this;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public ClearIndicesCacheRequest fieldDataCache(boolean fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        return this;
    }

    public boolean fileCache() {
        return this.fileCache;
    }

    public ClearIndicesCacheRequest fileCache(boolean fileCache) {
        this.fileCache = fileCache;
        return this;
    }

    public ClearIndicesCacheRequest fields(String ... fields) {
        this.fields = fields == null ? Strings.EMPTY_ARRAY : fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.queryCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeStringArrayNullable(this.fields);
        out.writeBoolean(this.requestCache);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_8_0)) {
            out.writeBoolean(this.fileCache);
        }
    }
}

