/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.datastream;

import io.skylite.common.Nullable;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.ParseField;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.metadata.DataStream;
import io.skylite.core.common.AbstractDiffable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATASTREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamInfo> dataStreams;

        public Response(List<DataStreamInfo> dataStreams) {
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readList(DataStreamInfo::new));
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.dataStreams);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATASTREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams);
        }

        public static class DataStreamInfo
        extends AbstractDiffable<DataStreamInfo>
        implements ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            DataStream dataStream;
            ClusterHealthStatus dataStreamStatus;
            @Nullable
            String indexTemplate;

            public DataStreamInfo(DataStream dataStream, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate) {
                this.dataStream = dataStream;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
            }

            public DataStreamInfo(StreamInput in) throws IOException {
                this(new DataStream(in), ClusterHealthStatus.readFrom(in), in.readOptionalString());
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName(), this.dataStream.getTimeStampField());
                builder.field(DataStream.INDICES_FIELD.getPreferredName(), this.dataStream.getIndices());
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                builder.field(STATUS_FIELD.getPreferredName(), (Object)this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)o;
                return this.dataStream.equals(that.dataStream) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate);
            }

            public int hashCode() {
                return Objects.hash(this.dataStream, this.dataStreamStatus, this.indexTemplate);
            }
        }
    }

    public static class Request
    extends ClusterManagerNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;

        public Request(String[] names) {
            this.names = names;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
        }

        public String[] names() {
            return this.names;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.names, request.names);
        }

        public int hashCode() {
            return Arrays.hashCode(this.names);
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.fromOptions(false, true, true, true, false, false, true, false);
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

