/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.replication;

import io.skylite.core.action.support.DefaultShardOperationFailedException;
import io.skylite.core.action.support.broadcast.BroadcastResponse;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.SegmentReplicationPerGroupStats;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class SegmentReplicationStatsResponse
extends BroadcastResponse {
    private final Map<String, List<SegmentReplicationPerGroupStats>> replicationStats;

    public SegmentReplicationStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.replicationStats = in.readMapOfLists(StreamInput::readString, SegmentReplicationPerGroupStats::new);
    }

    public SegmentReplicationStatsResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<SegmentReplicationPerGroupStats>> replicationStats, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.replicationStats = replicationStats;
    }

    public Map<String, List<SegmentReplicationPerGroupStats>> getReplicationStats() {
        return this.replicationStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.replicationStats.size() > 0) {
            for (String index : this.replicationStats.keySet()) {
                List<SegmentReplicationPerGroupStats> segmentReplicationStates = this.replicationStats.get(index);
                if (segmentReplicationStates == null || segmentReplicationStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("primary_stats");
                for (SegmentReplicationPerGroupStats segmentReplicationState : segmentReplicationStates) {
                    builder.startObject();
                    segmentReplicationState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMapOfLists(this.replicationStats, StreamOutput::writeString, (o, v) -> v.writeTo(o));
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }
}

