/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.rollover;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.admin.indices.rollover.Condition;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class MaxAgeCondition
extends Condition<TimeValue> {
    public static final String NAME = "max_age";

    public MaxAgeCondition(TimeValue value) {
        super(NAME);
        this.value = value;
    }

    public MaxAgeCondition(StreamInput in) throws IOException {
        super(NAME);
        this.value = TimeValue.timeValueMillis((long)in.readLong());
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        long indexAge = System.currentTimeMillis() - stats.indexCreated;
        return new Condition.Result(this, ((TimeValue)this.value).getMillis() <= indexAge);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(((TimeValue)this.value).getMillis());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, ((TimeValue)this.value).getStringRep());
    }

    public static MaxAgeCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
            return new MaxAgeCondition(TimeValue.parseTimeValue((String)parser.text(), (String)NAME));
        }
        throw new IllegalArgumentException("invalid token: " + String.valueOf((Object)parser.currentToken()));
    }
}

