/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.rollover;

import io.skylite.core.action.admin.indices.rollover.Condition;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.ByteSizeUnit;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;

public class MaxSizeCondition
extends Condition<ByteSizeValue> {
    public static final String NAME = "max_size";

    public MaxSizeCondition(ByteSizeValue value) {
        super(NAME);
        this.value = value;
    }

    public MaxSizeCondition(StreamInput in) throws IOException {
        super(NAME);
        this.value = new ByteSizeValue(in.readVLong(), ByteSizeUnit.BYTES);
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        return new Condition.Result(this, stats.indexSize.getBytes() >= ((ByteSizeValue)this.value).getBytes());
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(((ByteSizeValue)this.value).getBytes());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, ((ByteSizeValue)this.value).getStringRep());
    }

    public static MaxSizeCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
            return new MaxSizeCondition(ByteSizeValue.parseBytesSizeValue(parser.text(), NAME));
        }
        throw new IllegalArgumentException("invalid token: " + String.valueOf((Object)parser.currentToken()));
    }
}

