/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.action.admin.indices.shards;

import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.core.action.IndicesRequest;
import io.skylite.core.action.clustermanager.ClusterManagerNodeReadRequest;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.util.EnumSet;

public class IndicesShardStoresRequest
extends ClusterManagerNodeReadRequest<IndicesShardStoresRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpand();
    private EnumSet<ClusterHealthStatus> statuses = EnumSet.of(ClusterHealthStatus.YELLOW, ClusterHealthStatus.RED);

    public IndicesShardStoresRequest(String ... indices) {
        this.indices = indices;
    }

    public IndicesShardStoresRequest() {
    }

    public IndicesShardStoresRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int nStatus = in.readVInt();
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (int i = 0; i < nStatus; ++i) {
            this.statuses.add(ClusterHealthStatus.fromValue(in.readByte()));
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        out.writeVInt(this.statuses.size());
        for (ClusterHealthStatus status : this.statuses) {
            out.writeByte(status.value());
        }
        this.indicesOptions.writeIndicesOptions(out);
    }

    public IndicesShardStoresRequest shardStatuses(String ... shardStatuses) {
        this.statuses = EnumSet.noneOf(ClusterHealthStatus.class);
        for (String statusString : shardStatuses) {
            if ("all".equalsIgnoreCase(statusString)) {
                this.statuses = EnumSet.allOf(ClusterHealthStatus.class);
                return this;
            }
            this.statuses.add(ClusterHealthStatus.fromString(statusString));
        }
        return this;
    }

    public IndicesShardStoresRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public IndicesShardStoresRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public EnumSet<ClusterHealthStatus> shardStatuses() {
        return this.statuses;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }
}

